<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Gradetype
 *
 * @property $id
 * @property $nombre
 * @property $descripcion
 * @property $porcentaje
 * @property $created_at
 * @property $updated_at
 *
 * @property Grade[] $grades
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */

class Gradetype extends Model
{

  protected $table = 'tipos_notas';

  use HasFactory;

  static $rules = [
    'nombre' => 'required',
    'descripcion' => 'required',
    'porcentaje' => 'required'
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['nombre', 'descripcion', 'porcentaje'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function grades()
  {
    return $this->hasMany('App\Models\Grade', 'gradetype_id', 'id');
  }

  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function Scheduleingcalendar()
  {
    return $this->hasMany('App\Models\Scheduleingcalendar', 'scheduleingcalendar_id', 'id');
  }
}
