<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Grade
 *
 * @property $id
 * @property $activity_id
 * @property $gradetype_id
 * @property $subjectclass_id
 * @property $nombre
 * @property $created_at
 * @property $updated_at
 *
 * @property Activity $activity
 * @property Subjectclass $subjectclass
 * @property Gradetype $gradetype
 * @property Studentgrade[] $studentgrades
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Grade extends Model
{
    protected $table = 'notas';

    static $rules = [
		'nombre' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['activity_id','gradetype_id','subjectclass_id','nombre'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function activity()
    {
        return $this->hasOne('App\Models\Activity', 'id', 'activity_id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function subjectclass()
    {
        return $this->hasOne('App\Models\Subjectclass', 'id', 'subjectclass_id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function gradetype()
    {
        return $this->hasOne('App\Models\Gradetype', 'id', 'gradetype_id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function studentgrades()
    {
        return $this->hasMany('App\Models\Studentgrade', 'grade_id', 'id');
    }


}
