<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


/**
 * Class Schedule
 *
 * @property $id
 * @property $assignedprogramming_id
 * @property $student_id
 * @property $ruta
 * @property $archivo
 * @property $nota
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property Evaluateprogramming $subject
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Evaluateprogramming extends Model
{
    protected $table = 'evaluando_programacion';

    use HasFactory;

    static $rules = [
        'scheduleingcalendar_id' => 'required',
        'student_id' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['scheduleingcalendar_id','student_id', 'ruta', 'archivo', 'nota', 'estado'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */

    public function scheduleingcalendar()
    {
        return $this->hasMany('App\Models\Scheduleingcalendar', 'scheduleingcalendar_id', 'id');
    }

        /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */

     public function student()
     {
         return $this->hasMany('App\Models\Student', 'student_id', 'id');
     }
}
