<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Courseequivalence
 *
 * @property $id
 * @property $course_id1
 * @property $course_id2
 * @property $documento
 * @property $planequivalence_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Studentvalidation[] $studentvalidations
 * @property Course $course
 * @property Course $course
 * @property Planequivalence $planequivalence
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Courseequivalence extends Model
{
    protected $table = 'equivalencias_cursos';
    
    static $rules = [
		'course_id1' => 'required',
		'course_id2' => 'required',
		'documento' => 'required',
		'planequivalence_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['course_id1','course_id2','documento','planequivalence_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function studentvalidations()
    {
        return $this->hasMany('App\Models\Studentvalidation', 'courseequivalence_id', 'id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function course1()
    {
        return $this->hasOne('App\Models\Course', 'id', 'course_id1');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function course2()
    {
        return $this->hasOne('App\Models\Course', 'id', 'course_id2');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function planequivalence()
    {
        return $this->hasOne('App\Models\Planequivalence', 'id', 'planequivalence_id');
    }
    

}
