<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Content
 *
 * @property $id
 * @property $tipo
 * @property $titulo
 * @property $descripcion
 * @property $created_at
 * @property $updated_at
 *
 * @property Plan[] $plans
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Content extends Model
{
  protected $table = 'contenidos';

  use HasFactory;

  static $rules = [
    'tipo' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['tipo', 'titulo', 'descripcion', ];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function contentdetails()
  {
    return $this->hasMany('App\Models\Contetndetail', 'content_id', 'id');
  }
}
