<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Concepto
 *
 * @property $id
 * @property $nombre
 * @property $monto
 * @property $created_at
 * @property $updated_at
 *
 * @property Pago[] $pagos
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Concepto extends Model
{
  protected $table = 'conceptos';

  use HasFactory;

  static $rules = [
    'nombre' => 'required',
    'monto' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['nombre', 'monto'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function pagos()
  {
    return $this->hasMany('App\Models\Pago', 'concepto_id', 'id');
  }
}
