<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Classroom
 *
 * @property $id
 * @property $tipo
 * @property $numero
 * @property $piso
 * @property $capacidad
 * @property $created_at
 * @property $updated_at
 *
 * @property Schedule[] $schedules
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Classroom extends Model
{
  protected $table = 'aulas';

  use HasFactory;
    
    static $rules = [
		'tipo' => 'required',
		'numero' => 'required',
		'piso' => 'required',
		'capacidad' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['tipo','numero','piso','capacidad'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function schedules()
    {
        return $this->hasMany('App\Models\Schedule', 'classroom_id', 'id');
    }
    

}
