<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Applicant
 *
 * @property $id
 * @property $identificationtype_id
 * @property $nroidenti
 * @property $nombres
 * @property $apellido_pa
 * @property $apellido_ma
 * @property $fecnac
 * @property $correo
 * @property $tlf
 * @property $celular
 * @property $lugarnac
 * @property $direccion
 * @property $docdni
 * @property $doccertif
 * @property $docboucher
 * @property $docdatosper
 * @property $nota
 * @property $estado
 * @property $comentario
 * @property $modalidad
 * @property $tipomod
 * @property $estado_admision
 * @property $ubigeo_id
 * @property $genre_id
 * @property $admissionplan_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Admissionplan $admissionplan
 * @property Genre $genre
 * @property Ubigeo $ubigeo
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Applicant extends Model
{
    protected $table = 'postulantes';
    
    static $rules = [
		'identificationtype_id' => 'required',
		'nroidenti' => 'required',
		'nombres' => 'required',
		'apellido_pa' => 'required',
		'apellido_ma' => 'required',
		'fecnac' => 'required',
		'correo' => 'required',
		'tlf' => 'required',
		'celular' => 'required',
		'lugarnac' => 'required',
		'direccion' => 'required',
		'docdni' => 'required',
		'doccertif' => 'required',
		'docboucher' => 'required',
		'docdatosper' => 'required',
		'nota' => 'required',
		'estado' => 'required',
		'comentario' => 'required',
		'modalidad' => 'required',
		'tipomod' => 'required',
		'estado_admision' => 'required',
		'admissionplan_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     * @var array
     */
    protected $fillable = ['identificationtype_id','nroidenti','nombres','apellido_pa','apellido_ma','fecnac','correo','tlf','celular','lugarnac','direccion','docdni','doccertif','docboucher','docdatosper','nota','estado','comentario','modalidad','tipomod','estado_admision','ubigeo_id','genre_id','admissionplan_id'];
        
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function admissionplan()
    {
        return $this->hasOne('App\Models\Admissionplan', 'id', 'admissionplan_id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function genre()
    {
        return $this->hasOne('App\Models\Genre', 'id', 'genre_id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function ubigeo()
    {
        return $this->hasOne('App\Models\Ubigeo', 'id', 'ubigeo_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function identificationtype()
    {
        return $this->hasOne('App\Models\Identificationtype', 'id', 'identificationtype_id');
    }
    
}
