<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Admission
 *
 * @property $id
 * @property $anho
 * @property $fecinicio
 * @property $fecfin
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property Admissionplan[] $admissionplans
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Admission extends Model
{
  protected $table = 'admisiones';

  use HasFactory;
    
    static $rules = [
		'anho' => 'required',
		'fecinicio' => 'required',
		'fecfin' => 'required',
		'estado' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['anho','fecinicio','fecfin','estado'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function admissionplans()
    {
        return $this->hasMany('App\Models\Admissionplan', 'admission_id', 'id');
    }
    

}
