<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckSessionCompany
{
    public function handle(Request $request, Closure $next): Response
    {
        // Verificar si el usuario está autenticado en el guard 'company'
        if (!Auth::guard('company')->check()) {
            return redirect()->route('login');  // Redirigir si no está autenticado
        }

        $response = $next($request);

        $response->headers->set('Cache-Control', 'no-store, no-cache, must-revalidate, max-age=0');
        $response->headers->set('Cache-Control', 'post-check=0, pre-check=0', false);
        $response->headers->set('Pragma', 'no-cache');
        $response->headers->set('Expires', '0');

        return $response;
    }
}

