<?php

namespace App\Http\Controllers\home;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Genre;
use App\Models\Student;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function cantidadUser()
    {
        $result =  DB::table('usuarios')->select(DB::raw('COUNT(id) AS data_total'))->get();

        if ($result->count() > 0) {
            return response()->json(["status" => true, "mensaje" => 'Éxito, datos encontrados', "data" => $result]);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Error, datos null', "data" => []]);
        }
    }

    public function cantidadEstudiantes()
    {
        $result =  DB::table('estudiantes')->select(DB::raw('COUNT(id) AS data_total'))->get();

        if ($result->count() > 0) {
            return response()->json(["status" => true, "mensaje" => 'Éxito, datos encontrados', "data" => $result]);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Error, datos null', "data" => []]);
        }
    }
    
    public function cantidadDocentes()
    {
        $result =  DB::table('docentes')->select(DB::raw('COUNT(id) AS data_total'))->get();

        if ($result->count() > 0) {
            return response()->json(["status" => true, "mensaje" => 'Éxito, datos encontrados', "data" => $result]);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Error, datos null', "data" => []]);
        }
    }

    public function cantidadAdministradores()
    {
        $result =  DB::table('administradores')->select(DB::raw('COUNT(id) AS data_total'))->get();

        if ($result->count() > 0) {
            return response()->json(["status" => true, "mensaje" => 'Éxito, datos encontrados', "data" => $result]);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Error, datos null', "data" => []]);
        }
    }


    

    public function graficaBarras()
    {

        $result =  User::join('tipos_usuarios AS u', 'usuarios.usertype_id', '=', 'u.id')
            ->select(['u.tipo', DB::raw('COUNT(usuarios.id) AS datatotal')])
            ->selectRaw('IF(usuarios.estado = 1, "Activos", "Inactivos") as estadouser')
            ->groupBy('u.tipo', 'usuarios.estado')
            ->orderByRaw('u.tipo DESC, usuarios.estado DESC')
            ->get();

        if ($result->count() > 0) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, datos encontrados',
                "data" => $result
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, datos null',
                "data" => []
            ]);
        }
    }

        
    public function graficaDonusuno()
    {

        $result =  User::join('tipos_usuarios AS u', 'usuarios.usertype_id', '=', 'u.id')
            ->select([DB::raw('COUNT(usuarios.id) AS datatotal')])
            ->selectRaw('IF(usuarios.estado = 1, "Activos", "Inactivos") as estadouser')
            ->groupBy('usuarios.estado')
            ->orderByRaw('usuarios.estado DESC')
            ->get();


        if ($result->count() > 0) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, datos encontrados',
                "data" => $result
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, datos null',
                "data" => []
            ]);
        }
    }
    public function graficaDonusdos()
    {

        $result =  User::join('generos AS u', 'usuarios.genre_id', '=', 'u.id')
            ->select(['u.nombre', DB::raw('COUNT(usuarios.id) AS datatotal')])
            ->groupBy('u.nombre')
            ->orderBy('u.nombre', 'ASC')
            ->get();

        if ($result->count() > 0) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, datos encontrados',
                "data" => $result
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, datos null',
                "data" => []
            ]);
        }
    }


    public function graficaBarrasprogramas()
    {

        $result = Student::join('planes as pl', 'estudiantes.plan_id', '=', 'pl.id')
            ->join('programas as pr', 'pl.program_id', '=', 'pr.id')
            ->join('usuarios as u', 'estudiantes.user_id', '=', 'u.id')
            ->join('generos as gr', 'u.genre_id', '=', 'gr.id')
            ->select(
                'pr.nombre as programa',
                DB::raw('COUNT(CASE WHEN gr.nombre = "Masculino" THEN estudiantes.id END) AS masculino'),
                DB::raw('COUNT(CASE WHEN gr.nombre = "Femenino" THEN estudiantes.id END) AS femenino'),
                DB::raw('COUNT(CASE WHEN gr.nombre = "Otro" THEN estudiantes.id END) AS otros')
            )
            ->groupBy('pr.nombre')
            ->get();

        if ($result->count() > 0) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, datos encontrados',
                "data" => $result
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, datos null',
                "data" => []
            ]);
        }
    }
}
