<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Plan;
use App\Models\Student;
use App\Models\User;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;

class InscripcionesstudentsController extends Controller
{

    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $tipoacceso = 1;
                return view('admin.inscripcion.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function liststudents(Request $request)
    {
        if ($request->ajax()) {

            $idplan = $request->input('idplan');

            // query
            $data = DB::table('estudiantes AS e')
            ->join('usuarios AS u', 'u.id', '=', 'e.user_id')
            ->join('tipos_identificaciones AS it', 'it.id', '=', 'u.identificationtype_id')
            ->join('tipos_usuarios AS ut', 'ut.id', '=', 'u.usertype_id')
            ->join('ubigeos AS ub', 'ub.id', '=', 'u.ubigeo_id')
            ->join('generos AS g', 'g.id', '=', 'u.genre_id')
            ->join('planes AS pl', 'pl.id', '=', 'e.plan_id')
            ->join('programas AS pr', 'pr.id', '=', 'pl.program_id')
            ->select([
                'e.id AS idestudiantes',
                'e.estado AS estado_estudiante',
                'e.anho_ingreso AS anioingreso',
                'u.id AS iduser',
                'it.id AS ididentificationtype',
                'it.tipo AS tipoidenti',
                'u.nroidenti',
                'u.password',
                'u.nombres',
                'u.apellido_pa',
                'u.apellido_ma',
                DB::raw('CONCAT(u.apellido_pa, " ", u.apellido_ma) AS apellidos'),
                'u.fecnac',
                'u.correo',
                'u.telefono',
                'u.celular',
                'u.direccion',
                'u.estado AS estadoacin',
                'ut.id AS idusertype',
                'ut.tipo',
                'pr.nombre AS programa',
                'pl.id AS idplan',
                'pl.nombre AS plan',
                'ub.id AS idubigeo',
                DB::raw('SUBSTRING(ub.id, 1, 2) AS iddepartamento'),
                'ub.departamento',
                DB::raw('SUBSTRING(ub.id, 3, 2) AS idprovincia'),
                'ub.provincia',
                DB::raw('SUBSTRING(ub.id, 5, 2) AS iddistrito'),
                'ub.distrito',
                'g.id AS idgenre',
                'g.nombre AS nombregenre',
            ])
            ->where('e.plan_id', $idplan)
            ->get();

            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function list()
    {

        try {
            $result = Plan::join('programas AS pr', 'planes.program_id', '=', 'pr.id')
                ->select(['pr.id', 'pr.codprograma AS cod', 'pr.nombre AS programa', 'pr.nivel_formativo AS nf', DB::raw('COUNT(planes.program_id) AS totalplanes')])
                ->groupBy('pr.id', 'pr.codprograma', 'pr.nombre', 'pr.nivel_formativo')
                ->get();

            return response()->json($result);
        } catch (Exception $e) {

            return response()->json([
                'estado' => false,
                'type' => 'Catch',
                'mensaje' => $e
            ]);
        }
    }

    public function listplans(Request $request, $idprogram)
    {

        try {
            if ($request->ajax()) {
                $result = Plan::select('planes.id', 'planes.nombre AS plan', 'planes.tipo', 'planes.modalidad', 'planes.enfoque')
                    ->where('program_id', $idprogram)
                    ->get();
                return response()->json($result);
            } else {
                return response()->json([
                    'estado' => false,
                    'mensaje' => "error de consulta"
                ]);
            }
        } catch (Exception $e) {

            return response()->json([
                'estado' => false,
                'type' => 'Catch',
                'mensaje' => $e
            ]);
        }
    }


    public function store_plantilla(Request $request)
    {
        $datos = $request->input('datajsondos');
        $countUsers = 0;
        $countStudents = 0;
        $countrepetido = 0;
        $miArraynroidentiRepet = [];
        foreach ($datos as $dato) {

            $user = User::where('nroidenti', $dato[3])->first(); // Buscar el usuario por su nroidenti

            if ($user) {
                $countrepetido++;
                array_push($miArraynroidentiRepet, $dato[3]);
            } else {
                $item = new User();

                // TIPO IDENTI
                if ($dato[2] === 'DNI') {
                    $idtype = 1;
                } else if ($dato[2] === 'Carnét de Extranjería') {
                    $idtype = 2;
                }
                $item->identificationtype_id = $idtype;

                $item->nroidenti = $dato[3];
                $item->password = $dato[4];

                $item->nombres = $dato[5];
                $item->apellido_pa = $dato[6];
                $item->apellido_ma = $dato[7];

                // Convertir el número de Excel a una fecha legible con Carbon
                $baseDate = Carbon::createFromDate(1900, 1, 1);
                $date = $baseDate->addDays($dato[8] - 2); // Restamos 2 días ya que Excel considera el 1 de enero de 1900 como el día 1

                // Formatear la fecha a tu preferencia antes de insertarla en la base de datos
                $item->fecnac = $date->toDateString();

                $item->correo = $dato[9];
                $item->telefono = $dato[10];

                $item->celular = $dato[11];
                $item->direccion = $dato[12];
                $item->estado = "1";

                $item->ubigeo_id = "090101";    // HUANUCO - HUANUCO - HUANUCO


                // GENERO
                if ($dato[13] === 'Masculino') {
                    $idgenre = '1';
                } else if ($dato[13] === 'Femenino') {
                    $idgenre = '2';
                } else if ($dato[13] === 'Otros') {
                    $idgenre = '3';
                }
                $item->genre_id = $idgenre;


                $item->usertype_id = '3';

                // validar guardado
                if ($item->save()) {
                    $countUsers++;
                    // recoger id insertado
                    $newUserId = $item->id;
                    // nuevo objeto
                    $item2 = new Student();
                    // recoger datos
                    $item2->anho_ingreso = $dato[0];

                    if ($dato[1] === 'Regular') {
                        $item2->estado = '1';
                    } else if ($dato[1] === 'Matricula reservada') {
                        $item2->estado = '2';
                    } else if ($dato[1] === 'Licencia regular') {
                        $item2->estado = '3';
                    } else if ($dato[1] === 'Licencia discapacitado') {
                        $item2->estado = '4';
                    } else if ($dato[1] === 'Egresado') {
                        $item2->estado = '5';
                    } else  if ($dato[1] === 'Retirado') {
                        $item2->estado = '10';
                    }

                    $item2->plan_id = $request->input('idplan');
                    $item2->user_id = $newUserId;
                    // validar guardado
                    if ($item2->save()) {
                        $countStudents++;
                    }
                }
            }
        }

        if ($countUsers == count($datos) && $countStudents == count($datos)) {
            $result = ["status" => true, "mensaje" => 'Registros insertados correctamente'];
        } else if (($countUsers > 1 && $countrepetido > 1)) {
            $result = ["status" => true, "mensaje" => 'Registros Insertados: ' . $countUsers . ' Registros no insertados: ' . $countrepetido, "Repet" => $miArraynroidentiRepet];
        } else {
            $result = ["status" => false, "mensaje" => 'Error al insertar plantilla'];
        }
        return response()->json($result);

        // Comprobar si todos los datos se insertaron
    }

}
