<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Inicio</title>

    <!-- Tailwind -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        brand: {
                            navy: "var(--color-primario-p1)",
                            blue: "var(--color-primario-p2)",
                            sky: "var(--color-primario-p3)",
                            orange: "var(--color-secundario-s1)",
                            gray: "var(--color-neutral)",
                        },
                    },
                    container: {
                        center: true,
                        padding: { DEFAULT: '1rem', sm: '1.25rem', lg: '2rem', xl: '2.5rem' },
                    },
                },
            },
        };
    </script>

    <!-- Icons -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/lucide/0.263.1/lucide.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet" />
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js" defer></script>

    <!-- Tu CSS -->
    <link rel="stylesheet" href="/css/web/main.css" />

    <style>
      /* ===== Utilidades / efectos ===== */
      .group:hover .group-hover\:opacity-100 { opacity: 1; }
      .group:hover .group-hover\:visible { visibility: visible; }
    
      .program-card { transition: all .3s ease; }
      .program-card:hover { transform: translateY(-8px); }
    
      /* ===== Slider (hero) ===== */
      .carousel-slide {
        position: absolute; top: 0; left: 0;
        width: 100%; height: 100%;
        opacity: 0; transition: opacity 1s ease-in-out;
      }
      
      
      .carousel-slide.active { opacity: 1; }
    
      .carousel-dot.active {
        background-color: #fff !important;
        transform: scale(1.2);
      }
    
      /* NUEVO: siempre visibles */
        #prev-btn, #next-btn { opacity: 1 !important; }
    
      /* Tooltip simple para botones con title */
      button[title] { position: relative; }
      button[title]:hover::after {
        content: attr(title);
        position: absolute; bottom: 100%; left: 50%; transform: translateX(-50%);
        background: #333; color: #fff; padding: 5px 8px; border-radius: 6px;
        font-size: 12px; white-space: nowrap; z-index: 10;
      }
    
      /* ===== Sidebar (punto de navegación lateral) ===== */
      #sidebar { background-color: rgba(255, 255, 255, .8); }
      @media (min-width: 768px) { #sidebar { background-color: var(--color-primario-p1); } }
    
      #sidebar-nav .nav-dot > span { background-color: var(--color-primario-p1); }
      @media (min-width: 768px) { #sidebar-nav .nav-dot > span { background-color: #fff; } }
    
      #sidebar-nav .nav-dot { transition: background-color .2s ease; }
      #sidebar-nav .nav-dot:hover { background-color: var(--color-primario-p2); }
      #sidebar-nav .nav-dot:focus-visible {
        outline: 2px solid var(--color-primario-p2);
        outline-offset: 2px; border-radius: 9999px;
      }
    
      /* ===== FIX: flechas del carrusel a cada lado =====
         1) Reset para anular estilos heredados (left/right) en CUALQUIER botón del carrusel.
         2) Posicionamiento explícito de cada flecha. */
      #hero-carousel button {
        left: auto !important;
        right: auto !important;
      }
      #hero-carousel #prev-btn { left: .75rem !important; }
      #hero-carousel #next-btn { right: .75rem !important; }
    
      /* (Opcional) Si quedaron iconos antiguos de intentos previos, ocultarlos */
      #hero-carousel .fa-arrow-left,
      #hero-carousel .fa-arrow-right { display: none !important; }
      
      #heroDots .carousel-dot{
        /* forzamos sobre la clase "bg-white/60" del HTML */
        background-color: color-mix(in srgb, var(--color-primario-p1) 85%, white 15%) !important;
        border: 2px solid rgba(255,255,255,.75);
        opacity: .95;
        width: 12px; height: 12px;           /* un pelín más grandes */
        transition: transform .15s ease, background-color .15s ease, box-shadow .15s ease;
      }
      #heroDots .carousel-dot:hover{
        background-color: var(--color-primario-p1) !important;
        box-shadow: 0 2px 8px rgba(0,0,0,.25);
      }
      #heroDots .carousel-dot.active{
        background-color: var(--color-primario-p1) !important; /* activo en azul sólido */
        transform: scale(1.2);
        box-shadow: 0 0 0 2px rgba(255,255,255,.55), 0 2px 8px rgba(0,0,0,.3);
      }
      
      #hero-carousel .carousel-dot{
      background-color: color-mix(in srgb, var(--color-primario-p1) 85%, white 15%) !important;
      border: 2px solid rgba(255,255,255,.75);
      opacity: .95;
      width: 12px; height: 12px;
      transition: transform .15s ease, background-color .15s ease, box-shadow .15s ease;
    }
    #hero-carousel .carousel-dot:hover{
      background-color: var(--color-primario-p1) !important;
      box-shadow: 0 2px 8px rgba(0,0,0,.25);
    }
    #hero-carousel .carousel-dot.active{
      background-color: var(--color-primario-p1) !important;
      transform: scale(1.2);
      box-shadow: 0 0 0 2px rgba(255,255,255,.55), 0 2px 8px rgba(0,0,0,.3);
    }
    /* Efectos hover usando variables */
      .divide-y a:hover {
        background-color: color-mix(in srgb, var(--color-neutral) 10%, white 90%);
      }
    
      .divide-y a:hover i {
        color: var(--color-primario-p2) !important;
      }
    
      .divide-y a:hover span {
        color: var(--color-primario-p2) !important;
      }

      /* ===== ANIMACIONES DE ENTRADA AL SCROLL ===== */
      @keyframes fadeInUp {
        from {
          opacity: 0;
          transform: translateY(40px);
        }
        to {
          opacity: 1;
          transform: translateY(0);
        }
      }

      @keyframes fadeInLeft {
        from {
          opacity: 0;
          transform: translateX(-40px);
        }
        to {
          opacity: 1;
          transform: translateX(0);
        }
      }

      @keyframes fadeInRight {
        from {
          opacity: 0;
          transform: translateX(40px);
        }
        to {
          opacity: 1;
          transform: translateX(0);
        }
      }

      @keyframes scaleIn {
        from {
          opacity: 0;
          transform: scale(0.9);
        }
        to {
          opacity: 1;
          transform: scale(1);
        }
      }

      /* Estado inicial: oculto antes de animar */
      .animate-on-scroll {
        opacity: 0;
      }

      /* Clases de animación */
      .animate-fade-in-up {
        animation: fadeInUp 0.8s ease-out forwards;
      }

      .animate-fade-in-left {
        animation: fadeInLeft 0.8s ease-out forwards;
      }

      .animate-fade-in-right {
        animation: fadeInRight 0.8s ease-out forwards;
      }

      .animate-scale-in {
        animation: scaleIn 0.6s ease-out forwards;
      }

      /* Delays escalonados para elementos hijos */
      .stagger-1 { animation-delay: 0.1s; }
      .stagger-2 { animation-delay: 0.2s; }
      .stagger-3 { animation-delay: 0.3s; }
      .stagger-4 { animation-delay: 0.4s; }
      .stagger-5 { animation-delay: 0.5s; }
      .stagger-6 { animation-delay: 0.6s; }
    </style>

</head>



<body class="min-h-screen font-sans scroll-smooth"
      style="background-color:var(--color-neutral); color:var(--color-primario-p1);">

    <!-- Sidebar desktop / Bottom dots mobile -->
    <aside id="sidebar"
        class="fixed inset-x-0 bottom-0 md:inset-auto md:top-0 md:left-0 md:h-full md:w-20 z-50 flex md:flex-col items-center justify-center md:justify-start backdrop-blur md:backdrop-blur-0 border-t md:border-none">
        <!-- Logo (desktop only) -->
        <div class="hidden md:block mb-8 mt-8">
            <a href="{{ url('/') }}" class="inline-flex">
                <div class="text-white p-2 rounded-full" style="background-color: var(--color-secundario-s1);">
                    <i data-lucide="graduation-cap" class="h-6 w-6"></i>
                </div>
            </a>
        </div>

        <!-- Nav dots -->
        <nav id="sidebar-nav"
            class="w-full md:w-auto flex md:flex-col items-center justify-between md:justify-start gap-2 md:gap-6 px-3 py-2 md:py-0">
            <button onclick="scrollToSection('home')" class="nav-dot relative w-10 h-10 md:w-12 md:h-12 flex items-center justify-center transition-all rounded-full" data-section="home" title="Inicio"><span class="h-2.5 w-2.5 rounded-full"></span></button>
            <button onclick="scrollToSection('servicios')" class="nav-dot relative w-10 h-10 md:w-12 md:h-12 flex items-center justify-center transition-all rounded-full" data-section="servicios" title="Servicios"><span class="h-2.5 w-2.5 rounded-full"></span></button>
            <!--<button onclick="scrollToSection('estadisticas')" class="nav-dot relative w-10 h-10 md:w-12 md:h-12 flex items-center justify-center transition-all rounded-full" data-section="estadisticas" title="Estadísticas"><span class="h-2.5 w-2.5 rounded-full"></span></button>-->
            <button onclick="scrollToSection('programas')" class="nav-dot relative w-10 h-10 md:w-12 md:h-12 flex items-center justify-center transition-all rounded-full" data-section="programas" title="Programas"><span class="h-2.5 w-2.5 rounded-full"></span></button>
            <button onclick="scrollToSection('noticias')" class="nav-dot relative w-10 h-10 md:w-12 md:h-12 flex items-center justify-center transition-all rounded-full" data-section="noticias" title="Noticias"><span class="h-2.5 w-2.5 rounded-full"></span></button>
            <!--<button onclick="scrollToSection('coordinadores')" class="nav-dot relative w-10 h-10 md:w-12 md:h-12 flex items-center justify-center transition-all rounded-full" data-section="coordinadores" title="Coordinadores"><span class="h-2.5 w-2.5 rounded-full"></span></button>-->
            <button onclick="scrollToSection('porque')" class="nav-dot relative w-10 h-10 md:w-12 md:h-12 flex items-center justify-center transition-all rounded-full" data-section="porque" title="¿Por qué?"><span class="h-2.5 w-2.5 rounded-full"></span></button>
            <button onclick="scrollToSection('testimonios')" class="nav-dot relative w-10 h-10 md:w-12 md:h-12 flex items-center justify-center transition-all rounded-full" data-section="testimonios" title="Testimonios"><span class="h-2.5 w-2.5 rounded-full"></span></button>
        </nav>
    </aside>
    


    @include('header')

    <main class="pt-16 md:pt-0 md:pl-20">
        {{-- --------------------- HERO (con SLIDER) --------------------- --}}
        <section id="home" class="relative overflow-hidden">
            <!-- Slider a full width -->
            <div class="relative w-full h-[70vh] md:h-[80vh] overflow-hidden">
                <div id="hero-carousel"
                     class="absolute inset-0 w-full h-full"
                     data-autoplay="true" data-interval="7000">
                    @php $hasSlides = ($sliders ?? collect())->count() > 0; @endphp
        
                    {{-- Slides --}}
                    @if($hasSlides)
                        @foreach($sliders as $i => $s)
                            @php
                                $img = asset('public/images/' . ltrim($s->foto,'/'));
                            @endphp
                            <div class="carousel-slide {{ $i===0 ? 'active' : '' }}">
                                <img src="{{ $img }}" alt="Slide {{ $i+1 }}" class="w-full h-full object-cover">
                            </div>
                        @endforeach
                    @else
                        <div class="carousel-slide active">
                            <img src="{{ asset($hero->foto ?? 'images/no-photo.jpg') }}"
                                alt="{{ $hero->titulo ?? 'Imagen de portada' }}"
                                class="w-full h-full object-cover" />
                        </div>
                    @endif
        
                    {{-- Dots --}}
                    <div class="absolute bottom-4 left-1/2 -translate-x-1/2 flex gap-2 z-10">
                        @if($hasSlides)
                            @foreach($sliders as $i => $s)
                                <button class="carousel-dot h-3 w-3 rounded-full {{ $i===0 ? 'active' : '' }}" data-index="{{ $i }}"></button>
                            @endforeach
                        @endif
                    </div>
                    
                    
                    
                    
                    <!-- BOTONES DE FLECHAS DEL CARRUSEL -->
                    <button id="prev-btn"
                      class="absolute left-3 top-1/2 -translate-y-1/2 z-10 inline-flex items-center justify-center
                             h-10 w-10 rounded-full bg-white/90 hover:bg-white shadow-md ring-1 ring-black/10
                             opacity-0 transition-opacity"
                      aria-label="Anterior">
                      <i class="fa-solid fa-chevron-left"></i>
                    </button>
                    
                    <button id="next-btn"
                      class="absolute right-3 top-1/2 -translate-y-1/2 z-10 inline-flex items-center justify-center
                             h-10 w-10 rounded-full bg-white/90 hover:bg-white shadow-md ring-1 ring-black/10
                             opacity-0 transition-opacity"
                      aria-label="Siguiente">
                      <i class="fa-solid fa-chevron-right"></i>
                    </button>
                    <!-- BOTONES DE FLECHAS DEL CARRUSEL -->                    
                    
                    
                    
                    
                </div>
                <!-- Degradado overlay si quieres dar contraste -->
                <div class="absolute inset-0"></div>
            </div>
        
            <!-- Texto debajo del slider -->
            <div class="container px-4 md:px-6 py-10 md:py-16 animate-on-scroll">
                <div class="grid grid-cols-1 lg:grid-cols-12 gap-8 lg:gap-12 items-start">
                    <!-- Columna izquierda: Texto principal -->
                    <div class="lg:col-span-7">
                        @php
                            $titulo = $hero->titulo ?? 'Educación para el futuro';
                            $descripcion = $hero->descripcion ?? 'Formamos a los líderes del mañana con metodologías innovadoras, tecnología de vanguardia y un enfoque personalizado.';
                            $words = preg_split('/\s+/', trim($titulo)) ?: [];
                            $last = count($words) ? array_pop($words) : '';
                            $first = implode(' ', $words);
                        @endphp
                
                        <h1 class="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-bold leading-tight tracking-tight mb-6">
                            {{ $first }}
                            @if ($last !== '')
                                <span class="text-brand-orange" style="color: var(--color-secundario-s1);">{{ $last }}</span>
                            @endif
                        </h1>
                
                        <p class="text-base sm:text-lg md:text-xl text-gray-700 mb-6 text-justify">
                            {{ $descripcion }}
                        </p>
                
                        <div class="flex flex-wrap gap-4">
                            <a href="#programas"
                                class="inline-flex items-center rounded-full bg-brand-orange text-white px-6 py-3 text-sm md:text-base font-medium hover:bg-brand-orange/90"
                                style="background-color: var(--color-secundario-s1);">
                                Explorar programas
                                <i data-lucide="arrow-right" class="ml-2 h-4 w-4"></i>
                            </a>
                            <a href="#servicios"
                                class="inline-flex items-center rounded-full bg-white text-brand-navy px-6 py-3 text-sm md:text-base font-medium shadow hover:shadow-md"
                                style="color: var(--color-primario-p1);">
                                Nuestros servicios
                            </a>
                        </div>
                    </div>

                    <!-- Columna derecha: Tabla de acceso/login (colores administrables) -->
                    <div class="lg:col-span-5">
                      <div class="bg-white rounded-3xl shadow-xl border border-gray-100 overflow-hidden sticky top-24">
                    
                        <!-- Encabezado AZUL sólido -->
                        <div
                          class="px-6 py-4 flex items-center gap-3 rounded-t-3xl"
                          style="background-color: var(--color-primario-p1);"
                        >
                          <i class="fa-solid fa-user-circle text-white text-xl"></i>
                          <h3 class="text-xl font-bold text-white">Iniciar sesión</h3>
                        </div>
                    
                        <!-- Lista de opciones -->
                        <div class="divide-y divide-gray-100">
                          @forelse($sistemas as $sys)
                            <a
                              href="{{ $sys->link ?: '#' }}"
                              target="_blank" rel="noopener noreferrer"
                              class="group relative flex items-center justify-between px-6 py-4
                                     transition-all duration-200
                                     hover:bg-gray-50 hover:shadow-sm hover:-translate-y-0.5
                                     focus:outline-none focus:ring-2 focus:ring-brand-orange/40"
                              style="background-color: color-mix(in srgb, var(--color-neutral) 0%, white 100%);"
                            >
                              <!-- Acento animado a la izquierda -->
                              <span
                                class="pointer-events-none absolute left-0 top-0 h-full w-1
                                       rounded-r-full bg-[var(--color-secundario-s1)]
                                       origin-bottom scale-y-0 transition-transform duration-200
                                       group-hover:scale-y-100"
                              ></span>
                        
                              <div class="flex items-center gap-3">
                                <i
                                  class="{{ $sys->icono ?: 'fa-solid fa-link' }}
                                         text-xl motion-safe:transition-transform motion-safe:duration-200
                                         group-hover:scale-110"
                                  style="color: var(--color-primario-p1);"
                                ></i>
                        
                                <span
                                  class="font-medium transition-colors duration-200
                                         group-hover:text-brand-blue"
                                  style="color: var(--color-primario-p1);"
                                >
                                  {{ $sys->nombre }}
                                </span>
                              </div>
                        
                              <i
                                class="fa-solid fa-chevron-right text-xl
                                       motion-safe:transition-transform motion-safe:duration-200
                                       group-hover:translate-x-1"
                                style="color: var(--color-primario-p2);"
                              ></i>
                            </a>
                          @empty
                            <div class="px-6 py-5 text-sm text-gray-500">Próximamente más accesos…</div>
                          @endforelse
                        </div>
                      </div>
                    </div>
                </div>
            </div>
        </section>

        {{-- --------------------- SERVICIOS --------------------- --}}
        <section id="servicios" class="py-16 md:py-20 relative animate-on-scroll">
            <div class="container">
                <div class="mb-8 md:mb-12">
                    <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold mt-2">Nuestros Servicios</h2>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-5 md:gap-6">
                    @forelse($servicios ?? collect() as $s)
                        <article class="bg-white rounded-3xl p-6 md:p-8 shadow-lg hover:shadow-xl transition-shadow">
                            <div class="mb-5 md:mb-6 bg-brand-orange/15 p-4 rounded-2xl w-fit"
                                style="background-color: color-mix(in srgb, var(--color-secundario-s1) 15%, transparent);">
                                <i class="{{ $s->icono }} text-brand-orange text-2xl md:text-3xl fa-fw"
                                   style="color: var(--color-secundario-s1);"></i>
                            </div>
                            <h3 class="text-xl md:text-2xl font-bold mb-3 md:mb-4">{{ $s->nombre }}</h3>
                            <p class="text-gray-600 text-justify">{{ $s->descripcion }}</p>
                        </article>
                    @empty
                        <div class="col-span-full text-center text-gray-500">Próximamente publicaremos nuestros servicios.</div>
                    @endforelse
                </div>
            </div>
        </section>

        {{-- --------------------- ESTADÍSTICAS --------------------- --}}
        <!--<section id="estadisticas" class="py-16 md:py-20 bg-brand-navy text-white animate-on-scroll" style="background-color: var(--color-primario-p1);">-->
        <!--    <div class="container">-->
        <!--        <div class="mb-8 md:mb-12">-->
        <!--            <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold mt-2">Estadística</h2>-->
        <!--        </div>-->

        <!--        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-8">-->
        <!--            @foreach ($estadisticas as $item)-->
        <!--                <div class="relative">-->
        <!--                    <div class="absolute -inset-2 bg-gradient-to-br from-brand-orange/20 to-brand-sky/20 rounded-3xl blur-lg"-->
        <!--                        style="background-image: linear-gradient(to bottom right,-->
        <!--                            color-mix(in srgb, var(--color-secundario-s1) 20%, transparent),-->
        <!--                            color-mix(in srgb, var(--color-primario-p3) 20%, transparent));">-->
        <!--                    </div>-->
        <!--                    <div class="relative bg-brand-blue rounded-3xl p-6 md:p-8 h-full"-->
        <!--                         style="background-color: var(--color-primario-p2);">-->
        <!--                        <div class="mb-5 md:mb-6 bg-brand-navy/60 p-4 rounded-2xl w-fit">-->
        <!--                            <i class="{{ $item->icono }} text-brand-orange text-xl md:text-2xl"-->
        <!--                               style="color: var(--color-secundario-s1);"></i>-->
        <!--                        </div>-->
        <!--                        <div class="text-4xl md:text-5xl lg:text-6xl font-bold animate-count"-->
        <!--                             data-target="{{ (int) $item->cantidad }}"-->
        <!--                             data-prefix="{{ $loop->last ? '' : '+' }}" data-format="es-PE">0</div>-->
        <!--                        <p class="text-base md:text-lg text-gray-300 mt-3 md:mt-4">{{ $item->descripcion }}</p>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--            @endforeach-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</section>-->

        {{-- --------------------- PROGRAMAS --------------------- --}}
        <section id="programas" class="py-16 md:py-20 animate-on-scroll">
            <div class="container">
                <div class="mb-8 md:mb-12 text-center">
                    <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold mt-2">Programas De Estudio</h2>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
                    @forelse($programas as $prog)
                        <article class="program-card bg-white rounded-3xl overflow-hidden shadow-lg border border-gray-100 relative group cursor-pointer">
                            <div class="relative aspect-[16/10]">
                                <img src="{{ asset($prog->imagen ?: 'images/no-photo.jpg') }}"
                                     alt="{{ $prog->nombre }}" class="w-full h-full object-cover"
                                     onerror="this.src='{{ asset('images/no-photo.jpg') }}'">
                            </div>

                            <div class="p-6">
                                <h3 class="text-lg md:text-xl font-bold mb-2 md:mb-3 group-hover:text-brand-blue transition-colors">
                                    {{ $prog->nombre }}
                                </h3>
                                <p class="text-gray-600 text-justify mb-4">{{ $prog->descripcion }}</p>

                                <div class="mt-4">
                                    <a href="{{ route('programas.show.nombre', \Illuminate\Support\Str::slug($prog->nombre, '_')) }}"
                                       class="inline-flex items-center bg-brand-orange hover:bg-brand-orange/90 text-white rounded-full px-6 py-2.5 text-sm font-medium transition-colors focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-brand-orange"
                                       style="background-color: var(--color-secundario-s1);">
                                        Ver el programa
                                        <i data-lucide="arrow-right" class="ml-2 h-4 w-4"></i>
                                    </a>
                                </div>
                            </div>
                        </article>
                    @empty
                        <p class="col-span-full text-center text-gray-500">Aún no hay programas activos para mostrar.</p>
                    @endforelse
                </div>
            </div>
        </section>

        {{-- --------------------- NOTICIAS --------------------- --}}
        <section id="noticias" class="py-16 md:py-20 bg-brand-gray animate-on-scroll" style="background-color: var(--color-neutral);">
            <div class="container">
                <div class="mb-8 md:mb-12">
                    <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold mt-2">Últimas Noticias</h2>
                </div>



                @php
                  $principal   = $noticias->first();
                  $secundarias = $noticias->skip(1);
                @endphp


                <div class="grid grid-cols-1 md:grid-cols-12 gap-6 md:gap-8">
                    <div class="md:col-span-7 lg:col-span-8">
                        @if ($principal)
                            <article class="relative rounded-3xl overflow-hidden h-full min-h-[260px]">
                                <img src="{{ $principal->imagen_url }}" alt="{{ $principal->titulo }}" class="w-full h-full object-cover" />
                                <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent flex flex-col justify-end p-5 md:p-8">
                                    <h3 class="text-2xl md:text-3xl font-bold text-white mb-2">
                                        {{ $principal->titulo }}</h3>
                                    <p class="text-white/80 mb-3 md:mb-4 line-clamp-2 text-justify">
                                        {{ $principal->descripcion }}
                                    </p>
                                    <div class="flex items-center text-white/70 text-xs md:text-sm">
                                        <i data-lucide="calendar" class="h-4 w-4 mr-2"></i>
                                        <span>{{ $principal->fecha_human }}</span>
                                    </div>
                                    <a href="{{ url('/noticias/' . $principal->id) }}" class="absolute inset-0" aria-label="Leer noticia"></a>
                                </div>
                            </article>
                        @else
                            <div class="bg-white rounded-3xl p-8 text-center shadow">
                                <p class="text-gray-500">Aún no hay noticias publicadas.</p>
                            </div>
                        @endif
                    </div>

                    <div class="md:col-span-5 lg:col-span-4 flex flex-col gap-6 md:gap-8">
                        @forelse($secundarias as $n)
                            <article class="bg-white rounded-3xl overflow-hidden shadow-lg hover:shadow-xl transition-shadow">
                                <div class="relative aspect-[16/9]">
                                    <img src="{{ $n->imagen_url }}" alt="{{ $n->titulo }}" class="w-full h-full object-cover" />
                                    <a href="{{ url('/noticias/' . $n->id) }}" class="absolute inset-0" aria-label="Leer noticia"></a>
                                </div>
                                <div class="p-5 md:p-6">
                                    <h3 class="text-lg md:text-xl font-bold mb-1 md:mb-2 hover:text-brand-blue">
                                        {{ $n->titulo }}</h3>
                                    <p class="text-gray-600 text-sm md:text-base mb-3 md:mb-4 line-clamp-2">
                                        {{ $n->descripcion }}</p>
                                    <div class="flex items-center text-gray-500 text-xs md:text-sm">
                                        <i data-lucide="calendar" class="h-4 w-4 mr-2"></i>
                                        <span>{{ $n->fecha_human }}</span>
                                    </div>
                                </div>
                            </article>
                        @empty
                        @endforelse
                    </div>
                </div>

                <div class="mt-8 md:mt-12 text-center">
                    <a href="{{ url('/noticias') }}"
                       class="inline-flex items-center bg-brand-orange hover:bg-brand-orange/90 text-white rounded-full px-6 md:px-8 py-3 font-medium transition-colors"
                       style="background-color: var(--color-secundario-s1);">
                        Ver todas las noticias <i data-lucide="arrow-right" class="ml-2 h-4 w-4"></i>
                    </a>
                </div>
            </div>
        </section>











        <!--

        {{-- --------------------- COORDINADORES --------------------- --}}
        <section id="coordinadores" class="py-16 md:py-20 bg-white animate-on-scroll">
            <div class="container">
                <div class="mb-8 md:mb-12">
                    <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold mt-2">Plana Jerarquica</h2>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                    @forelse($coordinadores as $c)
                        <article class="bg-white rounded-3xl overflow-hidden shadow-lg border border-gray-100 hover:shadow-xl transition-shadow text-center p-6 md:p-8">
                            <div class="h-28 w-28 md:h-32 md:w-32 mx-auto border-4 border-white shadow-lg rounded-full overflow-hidden bg-brand-orange/15 flex items-center justify-center mb-4 md:mb-6"
                                style="background-color: color-mix(in srgb, var(--color-secundario-s1) 15%, transparent);">
                                <img src="{{ $c->imagen_url }}" alt="{{ $c->nombre }}" class="w-full h-full object-cover" />
                            </div>
                            <h3 class="text-lg md:text-xl font-bold mb-1">{{ $c->nombre }}</h3>
                            <p class="text-black font-medium text-sm md:text-base">{{ $c->cargo }}</p>
                        </article>
                    @empty
                        <div class="col-span-full">
                            <div class="bg-white rounded-3xl p-8 md:p-10 text-center shadow">
                                <p class="text-gray-500">Aún no hay coordinadores publicados.</p>
                            </div>
                        </div>
                    @endforelse
                </div>
            </div>
        </section>
        
        
        -->
        
        
        
        
        
        
        
        
        
        
        

        {{-- --------------------- POR QUÉ --------------------- --}}
        <section id="porque" class="py-16 md:py-20 bg-brand-gray animate-on-scroll" style="background-color: var(--color-neutral);">
            <div class="container">
                <div class="mb-8 md:mb-12">
                    <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold mt-2">¿Por qué estudiar en el IESTP?</h2>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
                    @forelse($beneficios as $b)
                        <article class="bg-white rounded-3xl p-6 md:p-8 shadow-lg hover:shadow-xl transition-all duration-300 text-center">
                            <div class="bg-brand-orange/15 p-3 md:p-4 rounded-full w-14 h-14 md:w-16 md:h-16 mx-auto mb-4 md:mb-6 flex items-center justify-center"
                                style="background-color: color-mix(in srgb, var(--color-secundario-s1) 15%, transparent);">
                                <i class="{{ $b->icono }} text-brand-orange text-2xl md:text-3xl" style="color: var(--color-secundario-s1);"></i>
                            </div>
                            <h3 class="text-lg md:text-xl font-bold mb-3 md:mb-4">{{ $b->nombre }}</h3>
                            <p class="text-gray-600 text-justify">{{ $b->descripcion }}</p>
                        </article>
                    @empty
                        <div class="col-span-full">
                            <div class="bg-white rounded-3xl p-8 md:p-10 text-center shadow">
                                <p class="text-gray-500">Aún no hay beneficios publicados.</p>
                            </div>
                        </div>
                    @endforelse
                </div>
            </div>
        </section>

        {{-- --------------------- TESTIMONIOS --------------------- --}}
        <section id="testimonios" class="py-16 md:py-20 bg-white animate-on-scroll">
            <div class="container">
                <div class="mb-8 md:mb-12">
                    <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold mt-2">¿Qué opinan nuestros estudiantes?</h2>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
                    @forelse($testimonios as $t)
                        <article class="bg-white rounded-3xl shadow-lg hover:shadow-xl transition-shadow p-6 md:p-8 text-center border border-gray-100">
                            <div class="flex justify-center mb-6">
                                <div class="h-24 w-24 md:h-28 md:w-28 lg:h-32 lg:w-32 border-4 border-gray-200 shadow-lg rounded-full overflow-hidden bg-gray-100 flex items-center justify-center">
                                    <img src="{{ $t->imagen_url }}" alt="{{ $t->nombre }}" class="w-full h-full object-cover" />
                                </div>
                            </div>
                            <div class="flex items-center justify-center gap-1 mb-4">
                                @for ($i = 1; $i <= 5; $i++)
                                    <i data-lucide="star" class="h-4 w-4 md:h-5 md:w-5 {{ $i <= (int) ($t->puntuacion ?? 0) ? 'fill-current text-yellow-400' : 'text-gray-300' }}"></i>
                                @endfor
                            </div>
                            <div class="mb-4">
                                <div class="flex justify-center mb-3">
                                    <svg class="h-8 w-8 md:h-10 md:w-10 text-brand-navy" fill="currentColor" viewBox="0 0 24 24" style="color: var(--color-primario-p1);">
                                        <path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z"></path>
                                    </svg>
                                </div>
                                <p class="text-gray-600 text-sm md:text-base leading-relaxed text-center px-2">
                                    {{ $t->descripcion }}</p>
                            </div>
                            <h4 class="font-bold text-base md:text-lg text-brand-navy mt-4"
                                style="color: var(--color-primario-p1);">{{ $t->nombre }}</h4>
                        </article>
                    @empty
                        <div class="col-span-full bg-white rounded-3xl p-8 shadow text-center text-gray-500">
                            Aún no hay testimonios publicados.
                        </div>
                    @endforelse
                </div>
            </div>
        </section>
    </main>

    @include('footer')

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => { if (window.lucide) window.lucide.createIcons(); });

        function scrollToSection(id) {
            const el = document.getElementById(id);
            if (!el) return;
            const y = el.getBoundingClientRect().top + window.pageYOffset - (window.innerWidth >= 768 ? 12 : 72);
            window.scrollTo({ top: y, behavior: 'smooth' });
        }
        window.scrollToSection = scrollToSection;

        const sections = Array.from(document.querySelectorAll('section[id]'));
        const dots = Array.from(document.querySelectorAll('.nav-dot'));
        const map = Object.fromEntries(dots.map(d => [d.dataset.section, d]));
        const io = new IntersectionObserver((entries) => {
            entries.forEach(e => {
                if (e.isIntersecting) {
                    const id = e.target.getAttribute('id');
                    dots.forEach(b => b.classList.remove('ring-2', 'ring-brand-orange'));
                    if (map[id]) map[id].classList.add('ring-2', 'ring-brand-orange');
                }
            });
        }, { rootMargin: '-40% 0px -55% 0px', threshold: 0.01 });
        sections.forEach(s => io.observe(s));

        const counters = document.querySelectorAll('.animate-count');
        const seen = new WeakSet();
        const cIo = new IntersectionObserver((entries) => {
            entries.forEach((entry) => {
                if (!entry.isIntersecting || seen.has(entry.target)) return;
                seen.add(entry.target);
                const el = entry.target;
                const target = parseInt(el.dataset.target || '0', 10);
                const prefix = el.dataset.prefix || '';
                const duration = 1200;
                const start = performance.now();
                function tick(now) {
                    const p = Math.min(1, (now - start) / duration);
                    const val = Math.floor(target * (0.2 + 0.8 * p));
                    el.textContent = prefix + new Intl.NumberFormat(el.dataset.format || 'es-PE').format(val);
                    if (p < 1) requestAnimationFrame(tick);
                }
                requestAnimationFrame(tick);
            });
        }, { threshold: 0.2 });
        counters.forEach(c => cIo.observe(c));
    </script>

    <!-- Slider del hero -->
    <script src="/js/web/slider-hero.js" defer></script>

    
    <!-- FUNCIONALIDAD CARRUSEL GENERAL HERO -->
    <script>
    (function () {
      function ready(fn){ document.readyState !== 'loading' ? fn() : document.addEventListener('DOMContentLoaded', fn); }
    
      ready(function(){
        const root   = document.getElementById('hero-carousel');
        if (!root) return;
    
        const slides = Array.from(root.querySelectorAll('.carousel-slide'));
        const dots   = Array.from(root.querySelectorAll('.carousel-dot'));
        const btnPrev= document.getElementById('prev-btn');
        const btnNext= document.getElementById('next-btn');
    
        if (!slides.length || !btnPrev || !btnNext) return;
    
        // 1) Si tu slider-hero.js expone un API, la usamos
        if (window.heroCarouselAPI && typeof window.heroCarouselAPI.next === 'function' && typeof window.heroCarouselAPI.prev === 'function') {
          btnNext.addEventListener('click', () => window.heroCarouselAPI.next());
          btnPrev.addEventListener('click', () => window.heroCarouselAPI.prev());
          return;
        }
    
        // 2) Fallback: alternar clases .active
        const getIndex = () => Math.max(0, slides.findIndex(s => s.classList.contains('active')));
        const goTo = (i) => {
          const n = slides.length;
          const idx = (i + n) % n;
          slides.forEach((s, j) => s.classList.toggle('active', j === idx));
          dots.forEach((d, j) => d?.classList.toggle('active', j === idx));
        };
    
        btnNext.addEventListener('click', () => { goTo(getIndex() + 1); });
        btnPrev.addEventListener('click', () => { goTo(getIndex() - 1); });
        dots.forEach((d, i) => d?.addEventListener('click', () => goTo(i)));
      });
    })();
    </script>
    <!-- FUNCIONALIDAD CARRUSEL GENERAL HERO -->

    
    {{-- ========================= MODAL POPUP (TAILWIND + JS) ========================= --}}
    @php
      $items = collect($activos ?? [])->filter(fn($p) => !empty($p->image))->values();
    @endphp
    
    @if($items->count())
      <div id="site-popup-overlay"
           class="fixed inset-0 z-[1000] hidden flex items-center justify-center bg-black/60 backdrop-blur-sm opacity-0 transition-opacity duration-300">
    
        {{-- Dialog: ancho/alto fijos (responsive) --}}
        <div id="site-popup-dialog" role="dialog" aria-modal="true" aria-labelledby="site-popup-title"
             class="relative w-[92vw] max-w-[900px] rounded-2xl bg-white shadow-2xl ring-1 ring-black/10
                    transform transition-transform duration-300 ease-out scale-95 translate-y-4
                    md:w-[860px]">
    
          {{-- Header (no cambia alto) --}}
          <div class="flex items-center justify-between px-4 py-3 md:px-5 border-b">
            <h3 id="site-popup-title" class="text-sm md:text-base font-semibold" style="color: var(--color-primario-p1);">
              Avisos importantes
            </h3>
            <button id="site-popup-close"
                    class="inline-flex h-9 w-9 items-center justify-center rounded-full hover:bg-gray-100 focus:outline-none focus:ring-2"
                    aria-label="Cerrar"><i class="fa-solid fa-xmark text-lg"></i></button>
          </div>
    
          {{-- Viewport fijo: alto fijo para que el contenido no refluya --}}
          <div class="px-3 pb-4 pt-3 md:px-5 md:pb-6">
            <div class="relative">
    
              {{-- Altura fija del carrusel (mobile/desktop) --}}
              <div id="popup-slides"
                   class="relative overflow-hidden rounded-xl
                          h-[70vh] md:h-[520px]">
    
                @foreach($items as $i => $p)
                  @php
                    $img = asset('images/' . ltrim($p->image,'/'));
                  @endphp
    
                  {{-- Cada slide ocupa TODO el alto fijo y usa flex para reservar espacio para titulo/fechas --}}
                  <div class="popup-slide {{ $i===0 ? 'block' : 'hidden' }} h-full">
                    <div class="flex h-full flex-col">
    
                      {{-- Titulo (altura auto pero pequeña; no afecta viewport gracias al contenedor fijo) --}}
                      @if(!empty($p->title))
                        <h4 class="text-base md:text-lg font-semibold mb-2 text-center shrink-0"
                            style="color: var(--color-primario-p1);">
                          {{ $p->title }}
                        </h4>
                      @endif
    
                      {{-- Imagen: se adapta dentro del espacio disponible sin deformar ni expandir el dialog --}}
                      <div class="flex-1 min-h-0">
                        <img src="{{ $img }}" alt="{{ $p->title ?? 'Aviso' }}"
                             class="w-full h-full object-contain rounded-xl"
                             onerror="this.style.display='none'">
                      </div>
    
                      {{-- Fechas (altura pequeña, no empuja el contenedor) --}}
                      <div class="mt-2 text-center text-xs text-gray-500 shrink-0">
                        @if(!empty($p->start_datetime))
                          Desde: {{ \Illuminate\Support\Carbon::parse($p->start_datetime)->format('d/m/Y H:i') }}
                        @endif
                        @if(!empty($p->end_datetime))
                          — Hasta: {{ \Illuminate\Support\Carbon::parse($p->end_datetime)->format('d/m/Y H:i') }}
                        @endif
                      </div>
    
                    </div>
                  </div>
                @endforeach
              </div>
    
              {{-- Controles centrados verticalmente respecto al viewport fijo --}}
              @if($items->count() > 1)
                <button id="popup-prev"
                        class="absolute left-2 top-1/2 -translate-y-1/2 inline-flex items-center justify-center
                               h-10 w-10 rounded-full bg-white/90 hover:bg-white shadow-md ring-1 ring-black/10">
                  <i class="fa-solid fa-chevron-left"></i>
                </button>
                <button id="popup-next"
                        class="absolute right-2 top-1/2 -translate-y-1/2 inline-flex items-center justify-center
                               h-10 w-10 rounded-full bg-white/90 hover:bg-white shadow-md ring-1 ring-black/10">
                  <i class="fa-solid fa-chevron-right"></i>
                </button>
    
                <div id="popup-dots" class="mt-3 flex items-center justify-center gap-2">
                  @foreach($items as $i => $p)
                    <button class="popup-dot h-2.5 w-2.5 rounded-full {{ $i===0 ? 'scale-125' : '' }}"
                            aria-label="Ir a aviso {{ $i+1 }}"
                            data-index="{{ $i }}"
                            style="background-color: color-mix(in srgb, var(--color-primario-p1) 85%, white 15%); border:2px solid rgba(0,0,0,.1)"></button>
                  @endforeach
                </div>
              @endif
    
            </div>
          </div>
        </div>
      </div>
    
      {{-- JS (sin cambios funcionales) --}}
      <script>
        (function() {
          const overlay = document.getElementById('site-popup-overlay');
          const dialog  = document.getElementById('site-popup-dialog');
          const btnClose= document.getElementById('site-popup-close');
    
          const slides  = Array.from(document.querySelectorAll('#popup-slides .popup-slide'));
          const dots    = Array.from(document.querySelectorAll('#popup-dots .popup-dot'));
          const btnPrev = document.getElementById('popup-prev');
          const btnNext = document.getElementById('popup-next');
    
          let idx = 0;
          let timer = null;
          const INTERVAL = 3500; // ms
    
          function show(i) {
            if (!slides.length) return;
            idx = (i + slides.length) % slides.length;
            slides.forEach((s, j) => s.classList.toggle('hidden', j !== idx));
            slides.forEach((s, j) => s.classList.toggle('block', j === idx));
            dots.forEach((d, j) => d?.classList.toggle('scale-125', j === idx));
          }
          function next() { show(idx + 1); }
          function prev() { show(idx - 1); }
    
          function startAuto() {
            if (slides.length <= 1) return;
            stopAuto();
            timer = setInterval(next, INTERVAL);
          }
          function stopAuto() {
            if (timer) { clearInterval(timer); timer = null; }
          }
    
          function openModal() {
            overlay.classList.remove('hidden');
            requestAnimationFrame(() => {
              overlay.classList.remove('opacity-0');
              dialog.classList.remove('scale-95', 'translate-y-4');
            });
            startAuto();
          }
          function closeModal() {
            overlay.classList.add('opacity-0');
            dialog.classList.add('scale-95','translate-y-4');
            stopAuto();
            setTimeout(() => overlay.classList.add('hidden'), 200);
          }
    
          // Cerrar
          btnClose?.addEventListener('click', closeModal);
          overlay?.addEventListener('click', (e) => { if (e.target === overlay) closeModal(); });
          document.addEventListener('keydown', (e) => { if (e.key === 'Escape') closeModal(); });
    
          // Controles
          btnNext?.addEventListener('click', () => { next(); startAuto(); });
          btnPrev?.addEventListener('click', () => { prev(); startAuto(); });
          dots.forEach(d => d?.addEventListener('click', () => { show(+d.dataset.index); startAuto(); }));
    
          // Mostrar siempre al cargar (tambien en recarga)
          document.addEventListener('DOMContentLoaded', () => {
            if (slides.length > 0) openModal();
          });
        })();
      </script>
    @endif
    {{-- ======================= / MODAL POPUP (TAILWIND + JS) ======================== --}}

    
    <!-- PARA QUE SE ABRA EL HEADER DEL CELULAR -->
    <script>
    (function () {
      const $ = id => document.getElementById(id);
      const hide = el => el && el.classList.add('hidden');
      const show = el => el && el.classList.remove('hidden');
      const isHidden = el => !el || el.classList.contains('hidden');
      const lockScroll = on => {
        document.documentElement.style.overflow = on ? 'hidden' : '';
        document.body.style.overscrollBehavior = on ? 'contain' : '';
      };
    
      // Abre/cierra el menú móvil
      window.toggleMobileMenu = function () {
        const menu = $('mobile-menu');
        const btn  = $('mobile-menu-button');
        const icnMenu  = $('menu-icon');
        const icnClose = $('close-icon');
        if (!menu || !btn) return;
    
        const willOpen = isHidden(menu);
        if (willOpen) {
          show(menu); show(icnClose); hide(icnMenu); lockScroll(true);
          btn.setAttribute('aria-expanded','true');
        } else {
          hide(menu); hide(icnClose); show(icnMenu); lockScroll(false);
          btn.setAttribute('aria-expanded','false');
        }
        // Re-pinta íconos de Lucide si hiciera falta
        if (window.lucide) window.lucide.createIcons();
      };
    
      // Abre/cierra submenús del acordeón móvil: 'nosotros', 'programas', etc.
      window.toggleSubmenu = function (name) {
        const body = $(`${name}-submenu`);
        const chev = $(`${name}-chevron`);
        if (!body) return;
        const willOpen = isHidden(body);
        if (willOpen) {
          show(body); chev && chev.classList.add('rotate-180');
        } else {
          hide(body); chev && chev.classList.remove('rotate-180');
        }
      };
    
      // Cierra el menú cuando haces click en un enlace dentro del menú móvil
      document.addEventListener('click', (e) => {
        const menu = $('mobile-menu');
        if (!menu || isHidden(menu)) return;
        const clickable = e.target.closest('#mobile-menu a, #mobile-menu button:not([onclick^="toggleSubmenu"])');
        if (clickable) window.toggleMobileMenu();
      });
    
      // Si cambias a viewport >= md, asegura que el menú quede cerrado
      window.addEventListener('resize', () => {
        if (window.innerWidth >= 768) {
          const menu = $('mobile-menu');
          const icnMenu  = $('menu-icon');
          const icnClose = $('close-icon');
          if (menu && !isHidden(menu)) hide(menu);
          show(icnMenu); hide(icnClose);
          lockScroll(false);
        }
      });
    })();
    </script>

    <!-- ANIMACIONES DE ENTRADA AL SCROLL -->
    <script>
    (function() {
      'use strict';
      
      // Configuración del Intersection Observer para las animaciones
      const animationObserver = new IntersectionObserver((entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            // Cuando el elemento entra en el viewport, añadimos la animación
            entry.target.classList.add('animate-fade-in-up');
            
            // Opcional: dejar de observar después de animar (animación única)
            animationObserver.unobserve(entry.target);
          }
        });
      }, {
        // El elemento debe estar al menos 15% visible para activar la animación
        threshold: 0.15,
        // Margen negativo para activar la animación un poco antes
        rootMargin: '0px 0px -50px 0px'
      });

      // Función para inicializar las animaciones
      function initScrollAnimations() {
        // Seleccionar todos los elementos con la clase animate-on-scroll
        const animatedElements = document.querySelectorAll('.animate-on-scroll');
        
        // Observar cada elemento
        animatedElements.forEach((element) => {
          animationObserver.observe(element);
        });

        console.log('[v0] Scroll animations initialized for', animatedElements.length, 'elements');
      }

      // Inicializar cuando el DOM esté listo
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initScrollAnimations);
      } else {
        initScrollAnimations();
      }
    })();
    </script>
    <!-- / ANIMACIONES DE ENTRADA AL SCROLL -->
    
</body>
</html>
