@php use Illuminate\Support\Str; @endphp
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Slider | Admin</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

  {{-- TUS CSS --}}
  <link rel="stylesheet" href="{{ asset('css/hero.css') }}">
  <link rel="stylesheet" href="{{ asset('css/admin/inicio/hero/hero.css') }}">
  <link rel="stylesheet" href="{{ asset('css/darkmode.css') }}">
  <link rel="stylesheet" href="{{ asset('css/content.css') }}">
</head>

<body
  data-titulo="Slider"
  class="has-sidebar"
  data-slider-base-url="{{ url('/admin/slider') }}"
>
  @include('include.preloader')
  @include('include.header')
  <aside class="sidebar-fixed">@include('include.sidebar')</aside>

  <main class="app-content">
    <div class="container-fluid px-3 px-md-4">
      <div class="card roles-card shadow-sm">
        <div class="card-body">

          {{-- Toolbar --}}
          <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 mb-3">
            <h5 class="mb-0 fw-bold">Sección Inicial – Slider</h5>

            <div class="d-flex flex-wrap align-items-center gap-2">
              <div class="search-wrap position-relative me-2">
                <i class="fa-solid fa-magnifying-glass search-icon"></i>
                <input type="text" class="form-control form-control-sm search-input" placeholder="Buscar..." data-filter-table>
              </div>

              <button class="btn btn-primary btn-pill btn-icon" id="btnNuevo">
                <i class="fa-solid fa-plus me-2"></i> Nuevo
              </button>
            </div>
          </div>

          {{-- Mensajes --}}
          @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              {{ session('success') }}
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          @endif

          {{-- Tabla --}}
          <div class="table-responsive">
            <table class="table table-bordered content-table align-middle" id="sliderTable">
              <thead>
                <tr>
                  <th style="width:70px">#</th>
                  <th>Imagen</th>
                  <th style="width:120px" class="text-center">Estado</th>
                  <th style="width:150px" class="text-center">Acciones</th>
                </tr>
              </thead>
              <tbody>
                @forelse($items as $row)
                  @php
                    $img = $row->foto ? asset('public/images/'.ltrim($row->foto,'/')) : asset('images/no-photo.jpg');
                  @endphp
                  <tr>
                    <td>{{ $row->id }}</td>
                    <td>
                      <button class="img-thumb-btn btn-show-img" title="Ver imagen"
                              data-img="{{ $img }}" data-nombre="Slider #{{ $row->id }}">
                        <i class="fa-regular fa-image"></i>
                      </button>
                    </td>
                    <td class="text-center">
                      @if($row->is_active)
                        <span class="badge bg-success">Activo</span>
                      @else
                        <span class="badge bg-secondary">Inactivo</span>
                      @endif
                    </td>
                    <td class="text-center">
                      <div class="d-inline-flex gap-1">
                        <button class="btn btn-warning btn-sm text-white btn-edit"
                                title="Editar"
                                data-id="{{ $row->id }}"
                                data-active="{{ (int)$row->is_active }}"
                                data-img="{{ $img }}">
                          <i class="fa-regular fa-pen-to-square"></i>
                        </button>

                        <button class="btn btn-danger btn-sm btn-delete"
                                title="Eliminar"
                                data-id="{{ $row->id }}">
                          <i class="fa-regular fa-trash-can"></i>
                        </button>
                      </div>
                    </td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="4" class="text-center text-muted">Aún no hay imágenes.</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>

        </div>
      </div>
    </div>
  </main>

  {{-- MODAL: Ver Imagen --}}
  <div class="modal fade" id="modalImagen" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 id="tituloImg" class="modal-title" style="color:#2563eb;">Imagen</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body text-center">
          <img id="vistaImg" src="" class="img-fluid rounded shadow-sm" alt="Imagen del slider">
        </div>
      </div>
    </div>
  </div>

  {{-- MODAL: Nuevo --}}
  <div class="modal fade" id="modalNuevo" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <form id="formNuevo" action="{{ route('slider.store') }}" method="POST" enctype="multipart/form-data">
          @csrf
          <div class="modal-header">
            <h5 class="modal-title" style="color:#2563eb;">Nueva imagen</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>

          <div class="modal-body">
            <div class="mb-3">
              <label class="form-label" style="color:#2563eb;">Seleccionar imagen</label>
              <input type="file" class="form-control" name="foto" accept="image/*" required>
              <div class="form-text">JPG/PNG/WEBP, máx. 4MB</div>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" value="1" id="nActivo" name="is_active" checked>
              <label class="form-check-label" for="nActivo" style="color:#2563eb;">Activo</label>
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
            <button type="submit" class="btn btn-primary">Guardar</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  {{-- MODAL: Editar --}}
  <div class="modal fade" id="modalEditar" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <form id="formEditar" action="#" method="POST" enctype="multipart/form-data">
          @csrf @method('PUT')
          <div class="modal-header">
            <h5 class="modal-title" style="color:#2563eb;">Editar imagen</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>

          <div class="modal-body">
            <div class="mb-3 text-center">
              <img id="ePreview" src="{{ asset('images/no-photo.jpg') }}" class="img-fluid rounded border" style="max-height:220px">
            </div>
            <div class="mb-3">
              <label class="form-label" style="color:#2563eb;">Cambiar imagen (opcional)</label>
              <input type="file" class="form-control" id="eImagen" name="foto" accept="image/*">
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" value="1" id="eActivo" name="is_active">
              <label class="form-check-label" for="eActivo" style="color:#2563eb;">Activo</label>
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
            <button type="submit" class="btn btn-primary">Guardar cambios</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  {{-- MODAL: Eliminar --}}
  <div class="modal fade" id="modalEliminar" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <form id="formEliminar" action="#" method="POST">
          @csrf @method('DELETE')
          <div class="modal-header">
            <h5 class="modal-title" style="color:#2563eb;">Eliminar imagen</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body">
            <p class="mb-0" style="color:#2563eb;">¿Seguro que deseas eliminar la imagen <strong id="delId"></strong>?</p>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
            <button type="submit" class="btn btn-danger">Eliminar</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  @include('include.footer')

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  {{-- JS del módulo --}}
  <script src="{{ asset('js/admin/inicio/slider/slider.js') }}" type="module"></script>

  {{-- tus scripts globales --}}
  <script src="{{ asset('js/titulo.js') }}" type="module"></script>
  <script src="{{ asset('js/admin/darkmode.js') }}" type="module"></script>
</body>
</html>
