@php use Illuminate\Support\Str; @endphp
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Popups programables</title>

  <meta name="csrf-token" content="{{ csrf_token() }}">

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

  <link rel="stylesheet" href="{{ asset('css/hero.css') }}">
  <link rel="stylesheet" href="{{ asset('css/admin/inicio/hero/hero.css') }}">
  <link rel="stylesheet" href="{{ asset('css/darkmode.css') }}">
</head>

<body class="has-sidebar">
  @include('include.preloader')
  @include('include.header')
  <aside class="sidebar-fixed">@include('include.sidebar')</aside>

  <main class="app-content">
    <div class="container-fluid px-3 px-md-4">
      <div class="card roles-card shadow-sm">
        <div class="card-body">

          <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 mb-3">
            <h5 class="mb-0 fw-bold">Popups programables</h5>
            <button
              class="btn btn-primary"
              data-bs-toggle="modal"
              data-bs-target="#modalGuardarPopup"
              data-mode="create"
              title="Nuevo popup">
              <i class="fa-solid fa-plus me-2"></i> Nuevo popup
            </button>
          </div>

          @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              {{ session('success') }}
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          @endif

          @if ($errors->any())
            <div class="alert alert-danger">
              <div class="fw-bold mb-1">No se pudo guardar:</div>
              <ul class="mb-0">
                @foreach ($errors->all() as $e)
                  <li>{{ $e }}</li>
                @endforeach
              </ul>
            </div>
          @endif

          <div class="table-responsive">
            <table class="table table-bordered content-table align-middle">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Titulo</th>
                  <th>Imagen</th>
                  <th>Inicio</th>
                  <th>Fin</th>
                  <th>Estado</th>
                  <th style="width:230px">Acciones</th>
                </tr>
              </thead>
              <tbody>
                @forelse ($records as $r)
                  @php
                    $foto = $r->image ?? '';
                    $fotoUrl = $foto ? asset('images/' . ltrim($foto, '/')) : asset('images/no-photo.jpg');
                  @endphp
                  <tr>
                    <td>{{ $r->id }}</td>
                    <td class="text-truncate" style="max-width:280px">{{ $r->title }}</td>
                    <td class="text-center">
                      <img
                        src="{{ $fotoUrl }}"
                        style="height:48px; cursor:pointer"
                        class="rounded border img-thumb"
                        alt="img"
                        data-foto="{{ $fotoUrl }}"
                        title="Ver">
                    </td>
                    <td>{{ optional($r->start_datetime)->format('Y-m-d H:i') ?? '' }}</td>
                    <td>{{ optional($r->end_datetime)->format('Y-m-d H:i') ?? '' }}</td>
                    <td>
                      @if($r->is_active)
                        <span class="badge text-bg-success">Activo</span>
                      @else
                        <span class="badge text-bg-secondary">Inactivo</span>
                      @endif
                    </td>
                    <td class="text-center">
                      <div class="btn-group" role="group" aria-label="Acciones popup">
                        {{-- Ver --}}
                        <button
                          type="button"
                          class="btn btn-sm btn-outline-secondary btn-view"
                          title="Ver"
                          data-foto="{{ $fotoUrl }}">
                          <i class="fa-solid fa-eye me-1"></i> Ver
                        </button>

                        {{-- Editar --}}
                        <button
                          type="button"
                          class="btn btn-sm btn-outline-primary btn-edit"
                          title="Editar"
                          data-action="{{ route('admin.inicio.popup.update', $r) }}"
                          data-title="{{ $r->title }}"
                          data-start="{{ optional($r->start_datetime)->format('Y-m-d\TH:i') }}"
                          data-end="{{ optional($r->end_datetime)->format('Y-m-d\TH:i') }}"
                          data-active="{{ (int)$r->is_active }}"
                          data-foto="{{ $fotoUrl }}">
                          <i class="fa-solid fa-pen-to-square me-1"></i> Editar
                        </button>

                        {{-- Eliminar --}}
                        <button
                          type="button"
                          class="btn btn-sm btn-outline-danger btn-delete"
                          title="Eliminar"
                          data-id="{{ $r->id }}"
                          data-name="{{ $r->title ?? 'Popup' }}"
                          data-url="{{ route('admin.inicio.popup.destroy', $r) }}">
                          <i class="fa-solid fa-trash me-1"></i> Eliminar
                        </button>
                      </div>

                      {{-- form oculto para fallback de borrado --}}
                      <form id="del-form-{{ $r->id }}" method="POST" action="{{ route('admin.inicio.popup.destroy', $r) }}" class="d-none">
                        @csrf
                        @method('DELETE')
                      </form>
                    </td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="7" class="text-center text-muted">Sin registros</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>

          {{ $records->links() }}

        </div>
      </div>
    </div>

    {{-- Modal crear/editar --}}
    <div class="modal fade" id="modalGuardarPopup" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <form
            id="formPopup"
            method="POST"
            enctype="multipart/form-data"
            action="{{ route('admin.inicio.popup.store') }}"
            data-store="{{ route('admin.inicio.popup.store') }}"
          >
            @csrf
            <div id="methodHolder"></div>
            <div class="modal-header">
              <h5 class="modal-title" id="modalGuardarPopupLabel" style="color:#2563eb;">Guardar popup</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>

            <div class="modal-body">
              <div class="mb-3">
                <label class="form-label" style="color:#2563eb;">Titulo</label>
                <input type="text" name="title" id="inpTitle" class="form-control" required maxlength="255">
              </div>

              <div class="mb-3">
                <label class="form-label" style="color:#2563eb;">Imagen</label>
                <input type="file" name="foto" id="inpFoto" accept="image/*" class="form-control">
                <div class="form-text">JPG, PNG, WEBP. &lt; 4MB.</div>
              </div>

              <div class="row g-3">
                <div class="col-md-6">
                  <label class="form-label" style="color:#2563eb;">Inicio (opcional)</label>
                  <input type="datetime-local" name="start_datetime" id="inpStart" class="form-control">
                </div>
                <div class="col-md-6">
                  <label class="form-label" style="color:#2563eb;">Fin (opcional)</label>
                  <input type="datetime-local" name="end_datetime" id="inpEnd" class="form-control">
                </div>
              </div>

              <div class="form-check form-switch mt-3">
                <input class="form-check-input" type="checkbox" id="inpActive" name="is_active" value="1" checked>
                <label class="form-check-label" for="inpActive" style="color:#2563eb;">Activo</label>
              </div>

              <div class="text-center mt-3">
                <img
                  id="previewNueva"
                  src="{{ asset('images/no-photo.jpg') }}"
                  class="img-fluid rounded mb-2 border"
                  style="max-height:180px"
                  alt="Nueva"
                  data-default="{{ asset('images/no-photo.jpg') }}"
                >
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
              <button type="submit" class="btn btn-primary">Guardar</button>
            </div>

          </form>
        </div>
      </div>
    </div>

    {{-- Modal de vista previa de imagen --}}
    <div class="modal fade" id="modalPreviewImg" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
          <div class="modal-header" style="border-bottom: 2px solid #2563eb;">
            <h6 class="modal-title fw-bold" style="color:#2563eb;">Vista previa</h6>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
          </div>
          <div class="modal-body text-center">
            <img id="previewImg" src="" alt="preview" class="img-fluid rounded border shadow-sm">
          </div>
        </div>
      </div>
    </div>

  </main>

  <br>
  @include('include.footer')

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script type="module" src="{{ asset('js/admin/inicio/popup/popup.js') }}"></script>
  <script src="{{ asset('js/titulo.js') }}" type="module"></script>
  <script src="{{ asset('js/admin/darkmode.js') }}" type="module"></script>
</body>
</html>
