{{-- resources/views/admin/mensajes_contacto/index.blade.php --}}
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Mensajes de Contacto</title>

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('css/documentos.css') }}">
    <link rel="stylesheet" href="{{ asset('css/darkmode.css') }}">
</head>
<body data-titulo="Mensajes de Contacto" class="has-sidebar">
    @include('include.preloader')
    @include('include.header')
    <aside class="sidebar-fixed">@include('include.sidebar')</aside>

    <main class="app-content">
        <div class="container-fluid px-3 px-md-4">
            <div class="card roles-card shadow-sm">
                <div class="card-body">

                    <div class="roles-toolbar d-flex flex-wrap align-items-center justify-content-between gap-2 mb-3">
                        <h5 class="mb-0 fw-bold">Mensajes de Contacto</h5>
                        <div class="d-flex flex-wrap align-items-center gap-2">
                            <div class="btn-toolbar gap-2 me-2">
                                <button class="btn btn-dark btn-pill btn-icon" title="Exportar a Excel" data-export-excel>
                                    <i class="fa-regular fa-file-excel me-2"></i> Excel
                                </button>
                                <button class="btn btn-dark btn-pill btn-icon" title="Exportar a PDF" data-export-pdf>
                                    <i class="fa-regular fa-file-pdf me-2"></i> PDF
                                </button>
                            </div>
                            <div class="search-wrap position-relative me-2">
                                <i class="fa-solid fa-magnifying-glass search-icon"></i>
                                <input type="text" class="form-control form-control-sm search-input" placeholder="Buscar...">
                            </div>
                        </div>
                    </div>

                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible fade show">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <div class="fw-bold mb-1">Ocurrió un problema:</div>
                            <ul class="mb-0">
                                @foreach ($errors->all() as $e)
                                    <li>{{ $e }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered content-table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Nombre</th>
                                    <th>Apellido</th>
                                    <th>Correo</th>
                                    <th>Mensaje</th>
                                    <th>Fecha</th>
                                    <th class="text-center">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($items as $row)
                                    <tr>
                                        <td>{{ $row->id }}</td>
                                        <td class="text-muted fw-semibold">{{ $row->nombre }}</td>
                                        <td class="text-muted">{{ $row->apellido }}</td>
                                        <td class="text-muted">{{ $row->correo }}</td>
                                        <td class="text-muted">
                                            {{-- Vista previa corta del mensaje --}}
                                            {{ Str::limit($row->mensaje, 80) }}
                                        </td>
                                        <td class="text-muted">{{ $row->created_at?->format('Y-m-d H:i') }}</td>
                                        <td class="text-center">
                                            <div class="d-inline-flex gap-1">
                                                
                                            
                                                
                                                {{-- botón eliminar --}}
                                                <button class="btn btn-danger btn-sm btn-delete"
                                                    title="Eliminar"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#modalEliminar"
                                                    data-delete-url="{{ route('admin.mensajes_contacto.destroy', $row) }}"
                                                    data-title="mensaje de {{ $row->nombre }} {{ $row->apellido }}">
                                                    <i class="fa-regular fa-trash-can"></i>
                                                </button>
                                                
                                                {{-- botón ver (opcional agregar fecha) --}}
                                                <button class="btn btn-info btn-sm text-white btn-view"
                                                    title="Ver"
                                                    data-nombre="{{ $row->nombre }}"
                                                    data-apellido="{{ $row->apellido }}"
                                                    data-correo="{{ $row->correo }}"
                                                    data-mensaje="{{ $row->mensaje }}"
                                                    data-fecha="{{ $row->created_at?->format('Y-m-d H:i') }}">
                                                    <i class="fa-regular fa-eye"></i>
                                                </button>

                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center text-muted">Sin registros.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </main>

    {{-- Modal VER --}}    {{-- Modal VER --}}
    <div class="modal fade" id="modalVer" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="border-radius:10px; box-shadow:0 4px 15px rgba(0,0,0,0.15);">
                <div class="modal-header" style="background-color:#f8f9fa;">
                    <h5 id="verTitulo" class="modal-title" style="color:#1e40af; font-weight:600;">
                        Mensaje
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
    
                <div class="modal-body" style="color:#111827; font-size:15px; line-height:1.6;">
                    <div class="mb-2">
                        <strong style="color:#000;">Nombre:</strong>
                        <span id="verNombre" style="color:#000; font-weight:500;"></span>
                    </div>
                    <div class="mb-2">
                        <strong style="color:#000;">Apellido:</strong>
                        <span id="verApellido" style="color:#000; font-weight:500;"></span>
                    </div>
                    <div class="mb-2">
                        <strong style="color:#000;">Correo:</strong>
                        <a id="verCorreo" href="#" target="_blank" style="color:#0d6efd; text-decoration:none; font-weight:500;"></a>
                    </div>
                    <div class="mb-2">
                        <strong style="color:#000;">Mensaje:</strong>
                    </div>
                    <div id="verMensaje" class="border rounded p-3" 
                         style="background-color:#f9fafb; color:#000; white-space:pre-wrap; font-weight:400;">
                    </div>
                </div>
    
                <div class="modal-footer" style="background-color:#f8f9fa;">
                    <button class="btn btn-primary" data-bs-dismiss="modal" style="font-weight:500; padding:6px 16px;">
                        Cerrar
                    </button>
                </div>
            </div>
        </div>
    </div>


    {{-- Modal ELIMINAR --}}
    <div class="modal fade" id="modalEliminar" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form id="formEliminar" action="#" method="POST">
                    @csrf @method('DELETE')
                    <div class="modal-header">
                        <h5 class="modal-title" style="color:#2563eb;">Eliminar</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body" style="color:#2563eb;">
                        ¿Seguro que deseas eliminar <strong id="delTitulo">este registro</strong>?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Sí, eliminar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @include('include.footer')

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('js/titulo.js') }}" type="module"></script>
    <script src="{{ asset('js/admin/mensajes_contacto/index.js') }}" type="module"></script>
    <script src="{{ asset('js/pagination.js') }}" type="module"></script>
    <script src="{{ asset('js/search.js') }}" type="module"></script>
    <script src="{{ asset('js/exportarPDF.js') }}" type="module"></script>
    <script src="{{ asset('js/exportarEXCEL.js') }}" type="module"></script>
    <script src="{{ asset('js/admin/darkmode.js') }}" type="module"></script>
</body>
</html>
