@php use Illuminate\Support\Str; @endphp
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Requisitos de Admisión</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('css/hero.css') }}">
    <link rel="stylesheet" href="{{ asset('css/darkmode.css') }}">

    {{-- SweetAlert2 (estilos opcionales, look moderno) --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
</head>

<body data-titulo="Registro de información sobre Requisitos de Admisión" class="has-sidebar">

@include('include.preloader')
@include('include.header')
<aside class="sidebar-fixed">@include('include.sidebar')</aside>

<main class="app-content">
    <div class="container-fluid px-3 px-md-4">
        <div class="card roles-card shadow-sm">
            <div class="card-body">
                <div class="roles-toolbar d-flex flex-wrap align-items-center justify-content-between gap-2 mb-3">
                    <h5 class="mb-0 fw-bold">Gestionar información sobre Requisitos de Admisión</h5>
                    <div class="d-flex flex-wrap align-items-center gap-2">
                        <div class="search-wrap position-relative me-2">
                            <i class="fa-solid fa-magnifying-glass search-icon"></i>
                            <input type="text" class="form-control form-control-sm search-input" placeholder="Buscar...">
                        </div>
                        <button class="btn btn-primary btn-pill btn-icon" type="button" data-bs-toggle="modal" data-bs-target="#modalNuevo">
                            <i class="fa-solid fa-plus me-2"></i> Nuevo registro
                        </button>
                    </div>
                </div>

                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <div class="fw-bold mb-1">No se pudo guardar:</div>
                        <ul class="mb-0">
                            @foreach ($errors->all() as $e)
                                <li>{{ $e }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="table-responsive">
                    <table class="table table-bordered content-table">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>Título</th>
                            <th>Descripción</th>
                            <th>Tipo Documento</th>
                            <th>Acciones</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($items as $row)
                            <tr id="row-{{ $row->id }}">
                                <td>{{ $row->id }}</td>
                                <td class="text-muted fw-semibold">{{ $row->titulo }}</td>
                                <td class="text-muted">{{ $row->descripcion }}</td>
                                <td class="text-muted">{{ $row->tipo_nombre ?? '—' }}</td>
                                <td class="text-center">
                                    <div class="d-inline-flex gap-1">
                                        {{-- Editar --}}
                                        <button
                                            type="button"
                                            class="btn btn-warning btn-sm text-white btn-edit"
                                            data-id="{{ $row->id }}"
                                            data-titulo="{{ e($row->titulo) }}"
                                            data-descripcion="{{ e($row->descripcion) }}"
                                            data-tipo="{{ $row->admision_documentos_id }}"
                                            data-active="{{ (int)($row->is_active ?? 0) }}"
                                            data-update="{{ route('admin-requisitos.update', ['requisito' => $row->id]) }}"
                                            title="Editar">
                                            <i class="fa-regular fa-pen-to-square"></i>
                                        </button>

                                        {{-- Eliminar (SweetAlert2) --}}
                                        <button
                                            type="button"
                                            class="btn btn-danger btn-sm btn-delete"
                                            title="Eliminar"
                                            data-action="{{ route('admin-requisitos.destroy', ['requisito' => $row->id]) }}"
                                            data-title="{{ e($row->titulo) }}">
                                            <i class="fa-regular fa-trash-can"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted">Sin registros.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    {{-- Modal Nuevo --}}
    <div class="modal fade" id="modalNuevo" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form action="{{ route('admin-requisitos.store') }}" method="POST">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title" style="color:#2563eb;">Nuevo requisito</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">Tipo Documento *</label>
                            <select name="admision_documentos_id" class="form-select" required>
                                <option value="" hidden>Seleccione…</option>
                                @foreach ($tipos as $t)
                                    <option value="{{ $t->id }}">{{ $t->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">Título *</label>
                            <input type="text" name="titulo" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">Descripción *</label>
                            <textarea name="descripcion" rows="3" class="form-control" required></textarea>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="createActive" name="is_active" value="1" checked>
                            <label class="form-check-label" for="createActive" style="color:#2563eb;">Activo</label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Modal Editar --}}
    <div class="modal fade" id="modalEditar" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form id="formEditar" action="#" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="modal-header">
                        <h5 class="modal-title" style="color:#2563eb;">Editar requisito</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">Tipo Documento *</label>
                            <select id="editTipo" name="admision_documentos_id" class="form-select" required>
                                @foreach ($tipos as $t)
                                    <option value="{{ $t->id }}">{{ $t->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">Título *</label>
                            <input type="text" id="editTitulo" name="titulo" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">Descripción *</label>
                            <textarea id="editDescripcion" name="descripcion" rows="3" class="form-control" required></textarea>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="editActive" name="is_active" value="1">
                            <label class="form-check-label" for="editActive" style="color:#2563eb;">Activo</label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Guardar cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Form de eliminación global (unico) --}}
    <form id="globalDeleteForm" action="" method="POST" class="d-none">
        @csrf
        @method('DELETE')
    </form>

</main>

@include('include.footer')

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

{{-- SweetAlert2 (JS) --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>

<script src="{{ asset('js/admin/admision_matricula/admision/requisitos/requisitos.js') }}" type="module"></script>
<script src="{{ asset('js/titulo.js') }}"></script>
<script src="{{ asset('js/search.js') }}"></script>
<script src="{{ asset('js/admin/darkmode.js') }}"></script>
</body>
</html>
