// public/js/web/slider-hero.js
(() => {
  const root = document.getElementById('hero-carousel');
  if (!root) return;

  const slides = Array.from(root.querySelectorAll('.carousel-slide'));
  if (slides.length === 0) return;

  const dots   = Array.from(root.querySelectorAll('.carousel-dot'));
  const prev   = root.querySelector('#prev-btn');
  const next   = root.querySelector('#next-btn');

  const autoplay = root.dataset.autoplay === 'true';
  const interval = parseInt(root.dataset.interval || '5000', 10);

  let idx = Math.max(0, slides.findIndex(s => s.classList.contains('active')));
  let timer = null;
  let locked = false;

  function show(i) {
    if (locked || i === idx) return;
    locked = true;

    slides[idx]?.classList.remove('active');
    dots[idx]?.classList.remove('active');

    idx = (i + slides.length) % slides.length;

    slides[idx]?.classList.add('active');
    dots[idx]?.classList.add('active');

    // pequeña ventana para evitar doble click rápido
    setTimeout(() => locked = false, 120);
  }

  function nextSlide() { show(idx + 1); }
  function prevSlide() { show(idx - 1); }

  // autoplay
  function start() { if (autoplay && slides.length > 1) timer = setInterval(nextSlide, interval); }
  function stop()  { if (timer) { clearInterval(timer); timer = null; } }

  // eventos
  next?.addEventListener('click', () => { stop(); nextSlide(); start(); });
  prev?.addEventListener('click', () => { stop(); prevSlide(); start(); });
  dots.forEach(d => d.addEventListener('click', () => { stop(); show(parseInt(d.dataset.index,10)); start(); }));

  // pausa en hover
  root.addEventListener('mouseenter', stop);
  root.addEventListener('mouseleave', start);

  // swipe móvil
  let sx = 0, dx = 0;
  root.addEventListener('touchstart', (e) => { sx = e.touches[0].clientX; dx = 0; stop(); }, {passive:true});
  root.addEventListener('touchmove', (e) => { dx = e.touches[0].clientX - sx; }, {passive:true});
  root.addEventListener('touchend', () => { if (Math.abs(dx) > 40) (dx < 0 ? nextSlide() : prevSlide()); start(); });

  // teclado
  root.addEventListener('keydown', (e) => {
    if (e.key === 'ArrowRight') { stop(); nextSlide(); start(); }
    if (e.key === 'ArrowLeft')  { stop(); prevSlide(); start(); }
  });
  root.tabIndex = 0; // focusable

  // pausa cuando se oculta la pestaña
  document.addEventListener('visibilitychange', () => {
    if (document.hidden) stop(); else start();
  });

  // kickstart
  start();
})();
