// public/js/web/popup-modal.js
(function () {
  const overlay = document.getElementById('site-popup-overlay');
  const dialog  = document.getElementById('site-popup-dialog');
  if (!overlay || !dialog) return;

  const btnClose  = document.getElementById('site-popup-close');
  const btnAccept = document.getElementById('site-popup-accept');

  function lockScroll(lock) {
    document.documentElement.style.overflow = lock ? 'hidden' : '';
    document.body.style.overflow = lock ? 'hidden' : '';
  }

  // ----- OPEN with animation (fade + scale/translate)
  function openModal() {
    overlay.classList.remove('hidden');
    overlay.classList.add('flex');

    // start state already set in HTML: overlay opacity-0, dialog scale-95 + translate-y-4
    requestAnimationFrame(() => {
      overlay.classList.remove('opacity-0');
      overlay.classList.add('opacity-100');
      dialog.classList.remove('scale-95', 'translate-y-4');
      dialog.classList.add('scale-100', 'translate-y-0');
    });

    lockScroll(true);
  }

  // ----- CLOSE with animation (reverse)
  function closeModal() {
    overlay.classList.remove('opacity-100');
    overlay.classList.add('opacity-0');
    dialog.classList.remove('scale-100', 'translate-y-0');
    dialog.classList.add('scale-95', 'translate-y-4');

    const onEnd = () => {
      overlay.classList.add('hidden');
      overlay.classList.remove('flex');
      overlay.removeEventListener('transitionend', onEnd);
      lockScroll(false);
    };
    overlay.addEventListener('transitionend', onEnd);
  }

  // Open after load with a tiny delay
  window.addEventListener('load', () => setTimeout(openModal, 250));

  // Close handlers
  btnClose && btnClose.addEventListener('click', closeModal);
  btnAccept && btnAccept.addEventListener('click', closeModal);
  overlay.addEventListener('click', (e) => { if (e.target === overlay) closeModal(); });
  document.addEventListener('keydown', (e) => { if (e.key === 'Escape') closeModal(); });
})();
