// public/js/admin/transparencia/inversiones/inversiones.js
document.addEventListener('DOMContentLoaded', () => {
  /* ---------- EDITAR ---------- */
  const modalEditEl = document.getElementById('modalEditar');
  const modalEdit   = modalEditEl ? new bootstrap.Modal(modalEditEl) : null;

  const formEdit = document.getElementById('formEditar');
  const eNombre  = document.getElementById('eNombre');
  const eDesc    = document.getElementById('eDescripcion');
  const eTipo    = document.getElementById('eTipo');
  const eActivo  = document.getElementById('eActivo');

  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id = btn.dataset.id;

      if (eNombre) eNombre.value = btn.dataset.nombre || '';
      if (eDesc)   eDesc.value   = btn.dataset.descripcion || '';
      if (eTipo)   eTipo.value   = btn.dataset.tipo || '';
      if (eActivo) eActivo.checked = parseInt(btn.dataset.active, 10) === 1;

      // Construir la URL PUT a partir del template inyectado por Blade
      const tpl = formEdit?.dataset.actionTemplate || '';
      if (!tpl) {
        console.error('Falta data-action-template en #formEditar');
        return;
      }
      formEdit.action = tpl.replace('__ID__', id);

      if (modalEdit) modalEdit.show();
    });
  });

  /* ---------- ELIMINAR (lleva el url del botn al form del modal) ---------- */
  const formDelete = document.getElementById('formEliminar');
  const delTitulo  = document.getElementById('delTitulo');

  document.addEventListener('click', (e) => {
    const btn = e.target.closest('.btn-delete');
    if (!btn) return;

    const url   = btn.getAttribute('data-delete-url'); // viene de route('inversiones.destroy', $row)
    const title = btn.getAttribute('data-title') || 'este registro';

    if (!url) {
      console.error('btn-delete sin data-delete-url');
      return;
    }
    if (formDelete) formDelete.setAttribute('action', url);
    if (delTitulo)  delTitulo.textContent = title;
  });

  /* ---------- PREVIEW PDF ---------- */
  const pdfFrame   = document.getElementById('pdfFrame');
  const openPdfBtn = document.getElementById('openPdfNewTab');
  const modalPdfEl = document.getElementById('modalPdf');
  const modalPdf   = modalPdfEl ? new bootstrap.Modal(modalPdfEl) : null;

  document.querySelectorAll('.pdf-thumb.clickable').forEach(el => {
    el.addEventListener('click', () => {
      const url = el.dataset.src;
      if (pdfFrame) pdfFrame.src = url;
      if (openPdfBtn) openPdfBtn.href = url;
      if (modalPdf) modalPdf.show();
    });
  });

  /* ---------- PREVIEW IMAGEN ---------- */
  const imgEl     = document.getElementById('imgPreview');
  const openImg   = document.getElementById('openImgNewTab');
  const modalImg  = document.getElementById('modalImg');
  const bsModalImg= modalImg ? new bootstrap.Modal(modalImg) : null;

  document.querySelectorAll('.img-thumb.clickable').forEach(el => {
    el.addEventListener('click', () => {
      const url = el.dataset.src;
      if (imgEl)   imgEl.src = url;
      if (openImg) openImg.href = url;
      if (bsModalImg) bsModalImg.show();
    });
  });

  /* ---------- Paginacin (si no usas tu pagination.js) ---------- */
  const tableBody = document.querySelector('.content-table tbody'); //  tu tabla real
  if (tableBody) {
    const rows      = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows  = rows.filter(r => r.children.length > 2);
    const pageSize  = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(Math.max(dataRows.length, 1) / pageSize);

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end   = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(r => tableBody.appendChild(r));
      if (pageRows.length === 0) {
        const tr = document.createElement('tr');
        tr.innerHTML = '<td colspan="7" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(tr);
      }
    }

    function createPagination() {
      const table = tableBody.closest('table');
      const host  = table ? table.parentElement : tableBody.parentElement;

      host.querySelectorAll('.inversiones-pagination').forEach(p => p.remove());

      const nav = document.createElement('nav');
      nav.className = 'inversiones-pagination mt-3';
      const prevDisabled = currentPage === 1 ? ' disabled' : '';
      const nextDisabled = currentPage === totalPages ? ' disabled' : '';

      nav.innerHTML = `<ul class="pagination justify-content-end">
        <li class="page-item${prevDisabled}">
          <a class="page-link" href="#" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a>
        </li>
        ${Array.from({ length: totalPages }, (_, i) =>
          `<li class="page-item${i+1===currentPage?' active':''}">
             <a class="page-link" href="#">${i+1}</a>
           </li>`
        ).join('')}
        <li class="page-item${nextDisabled}">
          <a class="page-link" href="#" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a>
        </li>
      </ul>`;

      host.appendChild(nav);

      const links = nav.querySelectorAll('.page-link');

      // 00
      links[0].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage > 1) {
          currentPage--;
          renderPage(currentPage);
          createPagination();
        }
      });

      // nmeros
      links.forEach((a, idx) => {
        if (idx > 0 && idx < totalPages + 1) {
          a.addEventListener('click', e => {
            e.preventDefault();
            currentPage = idx;
            renderPage(currentPage);
            createPagination();
          });
        }
      });

      // 03
      links[totalPages + 1].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage < totalPages) {
          currentPage++;
          renderPage(currentPage);
          createPagination();
        }
      });
    }

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }
});
