// resources/js/admin/transparencia/documentos/documentos_gestion.js
document.addEventListener('DOMContentLoaded', () => {
  // ====== EDITAR (submit nativo con _method=PUT) ======
  const editModal = new bootstrap.Modal(document.getElementById('modalEditar'));
  const formEdit  = document.getElementById('formEditar');
  const eNombre   = document.getElementById('editNombre');
  const eDesc     = document.getElementById('editDescripcion');
  const eActive   = document.getElementById('editActive');

  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id = btn.dataset.id;
      eNombre.value   = btn.dataset.nombre || '';
      eDesc.value     = btn.dataset.descripcion || '';
      eActive.checked = parseInt(btn.dataset.active, 10) === 1;

      formEdit.action = window.DOC_ROUTES.update.replace('__ID__', id);
      editModal.show();
    });
  });

  // ====== PREVIEW PDF ======
  const pdfModal = new bootstrap.Modal(document.getElementById('pdfModal'));
  const frame = document.getElementById('pdfFrame');
  const link  = document.getElementById('pdfNewTab');

  document.querySelectorAll('.pdf-open').forEach(btn => {
    btn.addEventListener('click', () => {
      const url = btn.dataset.url;
      frame.src = url;
      link.href = url;
      pdfModal.show();
    });
  });

  // ====== ELIMINAR (POST + _method=DELETE) ======
  const modalEliminar = document.getElementById('modalEliminar');
  const formEliminar  = document.getElementById('formEliminar');
  const delTitleEl    = document.getElementById('delTitulo');
  let currentDeleteUrl = '';

  modalEliminar.addEventListener('show.bs.modal', (ev) => {
    const trigger = ev.relatedTarget;
    currentDeleteUrl = trigger?.getAttribute('data-delete-url') || '';
    const title = trigger?.getAttribute('data-title') || 'este documento';
    if (delTitleEl) delTitleEl.textContent = title;
  });

  formEliminar.addEventListener('submit', async (e) => {
    e.preventDefault();
    if (!currentDeleteUrl) return;

    const submitBtn = formEliminar.querySelector('button[type="submit"]');
    const original  = submitBtn?.textContent || 'S, eliminar';
    if (submitBtn) { submitBtn.disabled = true; submitBtn.textContent = 'Eliminando...'; }

    try {
      const fd = new FormData();
      fd.append('_token', window.CSRF_TOKEN);
      fd.append('_method', 'DELETE'); // < mtodo simulado (funciona aunque el servidor bloquee DELETE)
      const res = await fetch(currentDeleteUrl, {
        method: 'POST',               // < siempre POST
        headers: { 'Accept': 'application/json' },
        body: fd
      });
      if (!res.ok) {
        let msg = 'No se pudo eliminar.';
        try { const data = await res.json(); if (data?.message) msg = data.message; } catch {}
        throw new Error(msg);
      }
      bootstrap.Modal.getInstance(modalEliminar)?.hide();
      window.location.reload();
    } catch (err) {
      alert(err?.message || 'Error al eliminar.');
    } finally {
      if (submitBtn) { submitBtn.disabled = false; submitBtn.textContent = original; }
    }
  });

  // ====== Paginacin simple sobre .content-table (opcional) ======
  const tableBody = document.querySelector('.content-table tbody');
  if (tableBody) {
    const rows      = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows  = rows.filter(r => r.querySelector('td'));
    const pageSize  = 10;
    let currentPage = 1;
    const totalPages = Math.ceil(dataRows.length / pageSize);

    const renderPage = (page) => {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end   = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(r => tableBody.appendChild(r));
      if (!pageRows.length) {
        const tr = document.createElement('tr');
        tr.innerHTML = '<td colspan="5" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(tr);
      }
    };

    const createPagination = () => {
      let pagination = document.querySelector('.documentos-pagination');
      if (pagination) pagination.remove();
      pagination = document.createElement('nav');
      pagination.className = 'documentos-pagination mt-3';

      const prevDisabled = currentPage === 1 ? ' disabled' : '';
      const nextDisabled = currentPage === totalPages ? ' disabled' : '';

      pagination.innerHTML = `<ul class="pagination justify-content-end">
        <li class="page-item${prevDisabled}">
          <a class="page-link" href="#" data-dir="prev" aria-label="Anterior">&laquo;</a>
        </li>
        ${Array.from({ length: totalPages }, (_, i) =>
          `<li class="page-item${i+1 === currentPage ? ' active' : ''}">
            <a class="page-link" href="#" data-page="${i+1}">${i+1}</a>
          </li>`).join('')}
        <li class="page-item${nextDisabled}">
          <a class="page-link" href="#" data-dir="next" aria-label="Siguiente">&raquo;</a>
        </li>
      </ul>`;

      const table = tableBody.closest('table');
      (table ? table.parentElement : tableBody.parentElement).appendChild(pagination);

      pagination.addEventListener('click', (e) => {
        const a = e.target.closest('a.page-link'); if (!a) return;
        e.preventDefault();
        const dir = a.getAttribute('data-dir');
        if (dir === 'prev' && currentPage > 1) currentPage--;
        else if (dir === 'next' && currentPage < totalPages) currentPage++;
        else {
          const p = parseInt(a.getAttribute('data-page'));
          if (!isNaN(p)) currentPage = p;
        }
        renderPage(currentPage);
        createPagination();
      });
    };

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }
});
