// public/js/admin/noticias/noticias.js
document.addEventListener('DOMContentLoaded', () => {
  /* ===============================
   *  MODALES / ELEMENTOS
   * =============================== */
  // Imagen
  const modalImgEl = document.getElementById('modalImg');
  const modalImg   = modalImgEl ? new bootstrap.Modal(modalImgEl) : null;
  const imgPreview = document.getElementById('imgPreview');
  const openImgNewTab = document.getElementById('openImgNewTab');

  // PDF
  const modalPdfEl = document.getElementById('modalPdf');
  const modalPdf   = modalPdfEl ? new bootstrap.Modal(modalPdfEl) : null;
  const pdfFrame   = document.getElementById('pdfFrame');
  const openPdfNewTab = document.getElementById('openPdfNewTab');

  // Editar
  const modalEditEl = document.getElementById('modalEditar');
  const modalEdit   = modalEditEl ? new bootstrap.Modal(modalEditEl) : null;
  const formEdit    = document.getElementById('formEditar');
  const eTitulo     = document.getElementById('eTitulo');
  const eDesc       = document.getElementById('eDescripcion');
  const eFecha      = document.getElementById('eFecha');
  const eActivo     = document.getElementById('eActivo');
  const eDocLink    = document.getElementById('eDocumentoLink');
  const eSinDoc     = document.getElementById('eSinDocumento');

  // Eliminar
  const modalDelEl  = document.getElementById('modalEliminar');
  const modalDel    = modalDelEl ? new bootstrap.Modal(modalDelEl) : null;
  const formDel     = document.getElementById('formEliminar');
  const delTitle    = document.getElementById('delTitulo');

  /* ===============================
   *  LIMPIEZAS AL CERRAR MODALES
   * =============================== */
  if (modalPdfEl) {
    modalPdfEl.addEventListener('hidden.bs.modal', () => {
      if (pdfFrame) pdfFrame.src = '';
      if (openPdfNewTab) openPdfNewTab.removeAttribute('href');
    });
  }
  if (modalImgEl) {
    modalImgEl.addEventListener('hidden.bs.modal', () => {
      if (imgPreview) imgPreview.src = '';
      if (openImgNewTab) openImgNewTab.removeAttribute('href');
    });
  }

  /* ===============================
   *  EVENT DELEGATION (clicks)
   * =============================== */
  document.addEventListener('click', (e) => {
    // 1) Abrir imagen en modal (thumbs con data-src y NO doc-thumb)
    const imgBtn = e.target.closest('.img-thumb');
    if (imgBtn && !imgBtn.classList.contains('doc-thumb')) {
      const src = imgBtn.dataset.src;
      if (!src || imgBtn.classList.contains('disabled')) return;
      if (imgPreview) imgPreview.src = src;
      if (openImgNewTab) openImgNewTab.href = src;
      modalImg && modalImg.show();
      return; // evita que caiga en otros handlers
    }

    // 2) Abrir PDF en modal (thumbs con .doc-thumb y data-src)
    const pdfBtn = e.target.closest('.doc-thumb');
    if (pdfBtn) {
      const url = pdfBtn.dataset.src;
      if (!url || pdfBtn.classList.contains('disabled')) return;
      if (pdfFrame) pdfFrame.src = url;
      if (openPdfNewTab) openPdfNewTab.href = url;
      modalPdf && modalPdf.show();
      return;
    }

    // 3) Editar (botón .btn-edit con data-*)
    const editBtn = e.target.closest('.btn-edit');
    if (editBtn) {
      const id = editBtn.dataset.id;
      const updateUrl = editBtn.dataset.updateUrl || (id ? `/admin/noticias/${id}` : '#');

      if (formEdit) formEdit.action = updateUrl;
      if (eTitulo) eTitulo.value = editBtn.dataset.titulo || '';
      if (eDesc)   eDesc.value   = editBtn.dataset.descripcion || '';
      if (eFecha)  eFecha.value  = editBtn.dataset.fecha || '';
      if (eActivo) eActivo.checked = editBtn.dataset.active === '1';

      const docUrl = editBtn.dataset.documentoUrl || '';
      if (eDocLink && eSinDoc) {
        if (docUrl) {
          eDocLink.href = docUrl;
          eDocLink.classList.remove('d-none');
          eSinDoc.classList.add('d-none');
        } else {
          eDocLink.classList.add('d-none');
          eSinDoc.classList.remove('d-none');
        }
      }

      modalEdit && modalEdit.show();
      return;
    }

    // 4) Eliminar (botón .btn-delete con data-delete-url y data-title)
    const delBtn = e.target.closest('.btn-delete');
    if (delBtn) {
      const url   = delBtn.getAttribute('data-delete-url') || '#';
      const title = delBtn.getAttribute('data-title') || 'esta noticia';
      if (formDel) formDel.setAttribute('action', url);
      if (delTitle) delTitle.textContent = title;
      modalDel && modalDel.show();
      return;
    }
  });
});
