// public/js/admin/nosotros/mision/mision.js
document.addEventListener('DOMContentLoaded', function () {
  // Utilidad para obtener Bootstrap.Modal sin reventar en modo module
  const getModal = (el) => {
    const B = window.bootstrap || bootstrap;
    return new B.Modal(el);
  };

  // ---------- Vista previa de ícono (Nuevo) ----------
  const newIcono = document.getElementById('newIcono');
  const newIconPreview = document.getElementById('newIconPreview');
  if (newIcono && newIconPreview) {
    newIcono.addEventListener('change', function () {
      newIconPreview.className = this.value || '';
    });
  }

  // ---------- Vista previa de ícono (Editar) ----------
  const editIconoSelect = document.getElementById('editIconoSelect');
  const editIconPreview = document.getElementById('editIconPreview');
  const editIconCode = document.getElementById('editIconCode');
  if (editIconoSelect && editIconPreview && editIconCode) {
    editIconoSelect.addEventListener('change', function () {
      editIconPreview.className = this.value || '';
      editIconCode.textContent = this.value || '';
    });
  }

  // ---------- Editar: cargar datos + abrir modal ----------
  const modalEditarEl = document.getElementById('modalEditarValor');
  const formEditar = document.getElementById('formEditarValor');

  document.querySelectorAll('.btn-edit').forEach((btn) => {
    btn.addEventListener('click', function () {
      // Setea campos
      const nombre = btn.dataset.nombre || '';
      const descripcion = btn.dataset.descripcion || '';
      const icono = btn.dataset.icono || '';
      const active = btn.dataset.active == '1';
      const id = btn.dataset.id;

      document.getElementById('editNombre').value = nombre;
      document.getElementById('editDescripcion').value = descripcion;

      if (editIconoSelect) {
        editIconoSelect.value = icono;
      }
      if (editIconPreview) editIconPreview.className = icono;
      if (editIconCode) editIconCode.textContent = icono;

      document.getElementById('editActive').checked = !!active;

      // Action del form
      const base = document.body.dataset.valoresBaseUrl;
      if (formEditar && base && id) {
        formEditar.action = `${base}/${id}`;
      }

      // Abre el modal
      if (modalEditarEl) {
        getModal(modalEditarEl).show();
      }
    });
  });

  // ---------- Eliminar: cargar datos + abrir modal ----------
  const modalEliminarEl = document.getElementById('modalEliminarValor');
  const formEliminar = document.getElementById('formEliminarValor');
  const delNombre = document.getElementById('delNombre');

  document.querySelectorAll('.btn-delete').forEach((btn) => {
    btn.addEventListener('click', function () {
      const id = btn.dataset.id;
      const nombre = btn.dataset.nombre || '';

      if (delNombre) delNombre.textContent = nombre;

      const base = document.body.dataset.valoresBaseUrl;
      if (formEliminar && base && id) {
        formEliminar.action = `${base}/${id}`;
      }

      if (modalEliminarEl) {
        getModal(modalEliminarEl).show();
      }
    });
  });

  // ---------- Paginación (corrige selector de la tabla) ----------
  const tableBody = document.querySelector('.content-table tbody');
  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(
      (row) => !row.classList.contains('no-data') && row.children.length > 3
    );
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(dataRows.length / pageSize) || 1;

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach((row) => tableBody.appendChild(row));
      if (pageRows.length === 0) {
        const noDataRow = document.createElement('tr');
        noDataRow.innerHTML =
          '<td colspan="5" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(noDataRow);
      }
    }

    function createPagination() {
      let pagination = document.querySelector('.mision-pagination');
      if (pagination) pagination.remove();

      pagination = document.createElement('nav');
      pagination.className = 'mision-pagination mt-3';

      const list =
        '<ul class="pagination justify-content-end">' +
        `<li class="page-item${currentPage === 1 ? ' disabled' : ''}">
          <a class="page-link" href="#" data-nav="prev" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a>
        </li>` +
        Array.from({ length: totalPages }, (_, i) => {
          const n = i + 1;
          return `<li class="page-item${n === currentPage ? ' active' : ''}">
            <a class="page-link" href="#" data-page="${n}">${n}</a>
          </li>`;
        }).join('') +
        `<li class="page-item${currentPage === totalPages ? ' disabled' : ''}">
          <a class="page-link" href="#" data-nav="next" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a>
        </li>` +
        '</ul>';

      pagination.innerHTML = list;

      const table = tableBody.closest('table');
      const container = table ? table.parentElement : tableBody.parentElement;
      const prevPaginations = container.querySelectorAll('.mision-pagination');
      prevPaginations.forEach((p) => p.remove());
      container.appendChild(pagination);

      // Eventos
      pagination.addEventListener('click', (e) => {
        const a = e.target.closest('a.page-link');
        if (!a) return;
        e.preventDefault();

        if (a.dataset.nav === 'prev' && currentPage > 1) currentPage--;
        else if (a.dataset.nav === 'next' && currentPage < totalPages) currentPage++;
        else if (a.dataset.page) currentPage = parseInt(a.dataset.page, 10);

        renderPage(currentPage);
        createPagination();
      });
    }

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }
});
