// public/js/admin/mensajes_contacto/index.js
document.addEventListener('DOMContentLoaded', () => {
  // Asegúrate que el bundle de Bootstrap esté cargado (expuesto como window.bootstrap)
  const modalEl = document.getElementById('modalVer');
  const modalVer = new bootstrap.Modal(modalEl, { backdrop: 'static', keyboard: true });

  const $ = (sel) => document.querySelector(sel);

  // Delegación para el botón "ojo"
  document.addEventListener('click', (e) => {
    const btn = e.target.closest('.btn-view');
    if (!btn) return;

    const nombre   = btn.dataset.nombre   || '';
    const apellido = btn.dataset.apellido || '';
    const correo   = btn.dataset.correo   || '';
    const mensaje  = btn.dataset.mensaje  || '';
    const fecha    = btn.dataset.fecha    || '';

    // Título y campos
    $('#verTitulo').textContent   = `Mensaje de ${nombre} ${apellido}`;
    $('#verNombre').textContent   = nombre;
    $('#verApellido').textContent = apellido;

    const aCorreo = $('#verCorreo');
    aCorreo.textContent = correo;
    aCorreo.href = correo ? `mailto:${correo}` : '#';

    $('#verMensaje').textContent = mensaje;

    // Si quieres mostrar la fecha debajo del título, añade en el header un <small id="verFecha"></small>
    // y descomenta esta línea:
    // $('#verFecha').textContent = fecha ? `Recibido: ${fecha}` : '';

    modalVer.show();
  });

  // Delegación para “Eliminar” (lo que ya tenías)
  document.addEventListener('click', function (e) {
    const btn = e.target.closest('.btn-delete');
    if (!btn) return;

    const url = btn.getAttribute('data-delete-url');
    const title = btn.getAttribute('data-title') || 'este registro';

    const form = document.getElementById('formEliminar');
    const delTitle = document.getElementById('delTitulo');

    form.setAttribute('action', url);
    delTitle.textContent = title;
  });
});

