// public/js/admin/links_institucionales/links.js
document.addEventListener('DOMContentLoaded', () => {
  // Instancia correcta del modal (elemento, no selector)
  const modalEditEl = document.getElementById('modalEditar');
  const modalEdit = modalEditEl ? new bootstrap.Modal(modalEditEl) : null;

  const formEdit = document.getElementById('formEditar');
  const eNombre  = document.getElementById('eNombre');
  const eEnlace  = document.getElementById('eEnlace');
  const eActivo  = document.getElementById('eActivo');

  // Abrir modal Editar y setear action desde data-edit-url
  document.addEventListener('click', (e) => {
    const btn = e.target.closest('.btn-edit');
    if (!btn) return;

    const nombre = btn.dataset.nombre || '';
    const enlace = btn.dataset.enlace || '';
    const activo = parseInt(btn.dataset.active || '0', 10) === 1;

    eNombre.value = nombre;
    eEnlace.value = enlace;
    eActivo.checked = activo;

    // URL de actualizacin tomada del botn (evita usar Blade en JS externo)
    formEdit.action = btn.dataset.editUrl;

    modalEdit && modalEdit.show();
  });

  // Preparar modal Eliminar con la URL y el ttulo
  document.addEventListener('click', function (e) {
    const btn = e.target.closest('.btn-delete');
    if (!btn) return;

    const url = btn.getAttribute('data-delete-url');
    const title = btn.getAttribute('data-title') || 'este registro';

    const form = document.getElementById('formEliminar');
    const delTitle = document.getElementById('delTitulo');

    if (form && url) form.setAttribute('action', url);
    if (delTitle) delTitle.textContent = title;
  });

  // Si vienes de errores del create, abre el modal nuevo
  if (window.linksShowNuevoModal) {
    const modalNuevoEl = document.getElementById('modalNuevo');
    if (modalNuevoEl) new bootstrap.Modal(modalNuevoEl).show();
  }
});
