document.addEventListener('DOMContentLoaded', () => {
  const modalEditarEl   = document.getElementById('modalEditar');
  const modalEliminarEl = document.getElementById('modalEliminar');
  const modalEditar     = modalEditarEl ? new bootstrap.Modal(modalEditarEl) : null;
  const modalEliminar   = modalEliminarEl ? new bootstrap.Modal(modalEliminarEl) : null;

  // Vista previa de ícono al crear
  const iconCreate = document.getElementById('iconCreate');
  const iconCreatePreview = document.getElementById('iconCreatePreview');
  if (iconCreate && iconCreatePreview) {
    iconCreate.addEventListener('change', e => {
      iconCreatePreview.innerHTML = e.target.value ? `<i class="${e.target.value}"></i>` : '';
    });
  }

  // Editar
  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      if (!modalEditar) return;

      // Datos del botón
      const nombre = btn.dataset.nombre || '';
      const link = btn.dataset.link || '';
      const icono = btn.dataset.icono || '';
      const actionUrl = btn.dataset.updateUrl || `/admin/sistemas/${btn.dataset.id}`;

      // Setear valores
      document.getElementById('editNombre').value = nombre;
      document.getElementById('editLink').value = link;

      const selectIcon = document.getElementById('iconEdit');
      const preview = document.getElementById('iconEditPreview');
      if (selectIcon) {
        selectIcon.value = icono;
        if (preview) preview.innerHTML = icono ? `<i class="${icono}"></i>` : '';
        selectIcon.onchange = (e) => {
          preview.innerHTML = `<i class="${e.target.value}"></i>`;
        };
      }

      document.getElementById('formEditar').action = actionUrl;
      modalEditar.show();
    });
  });

  // Eliminar
  document.querySelectorAll('.btn-delete').forEach(btn => {
    btn.addEventListener('click', () => {
      if (!modalEliminar) return;

      const nombre = btn.dataset.nombre || '—';
      const actionUrl = btn.dataset.deleteUrl || `/admin/sistemas/${btn.dataset.id}`;

      document.getElementById('delNombre').textContent = nombre;
      document.getElementById('formEliminar').action = actionUrl;
      modalEliminar.show();
    });
  });
});
