document.addEventListener('DOMContentLoaded', () => {
  // Modal Guardar
  const modalEl = document.getElementById('modalGuardarPopup');
  const modal = modalEl && window.bootstrap ? new bootstrap.Modal(modalEl) : null;

  // Modal Preview
  const modalPrevEl = document.getElementById('modalPreviewImg');
  const modalPrev = modalPrevEl && window.bootstrap ? new bootstrap.Modal(modalPrevEl) : null;
  const previewTarget = document.getElementById('previewImg');

  // Form y campos
  const form = document.getElementById('formPopup');
  const methodHolder = document.getElementById('methodHolder');
  const inpTitle = document.getElementById('inpTitle');
  const inpFoto = document.getElementById('inpFoto');
  const inpStart = document.getElementById('inpStart');
  const inpEnd = document.getElementById('inpEnd');
  const inpActive = document.getElementById('inpActive');
  const previewNueva = document.getElementById('previewNueva');

  // CSRF
  function getCsrfToken() {
    const meta = document.querySelector('meta[name="csrf-token"]');
    if (meta?.content) return meta.content;
    const input = document.querySelector('input[name="_token"]');
    return input?.value || '';
  }

  function setBtnLoading(btn, loading) {
    if (!btn) return;
    if (loading) {
      btn.dataset.originalHtml = btn.innerHTML;
      btn.disabled = true;
      btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Procesando...';
    } else {
      btn.disabled = false;
      if (btn.dataset.originalHtml) {
        btn.innerHTML = btn.dataset.originalHtml;
        delete btn.dataset.originalHtml;
      }
    }
  }

  // Crear
  document.querySelectorAll('[data-bs-target="#modalGuardarPopup"][data-mode="create"]').forEach(btn => {
    btn.addEventListener('click', () => {
      if (!form) return;
      form.action = form.getAttribute('data-store') || form.getAttribute('action') || form.action;
      if (methodHolder) methodHolder.innerHTML = '';
      if (inpTitle) inpTitle.value = '';
      if (inpStart) inpStart.value = '';
      if (inpEnd) inpEnd.value = '';
      if (inpActive) inpActive.checked = true;
      if (previewNueva) previewNueva.src = previewNueva.dataset?.default || previewNueva.src;
      if (inpFoto) { inpFoto.value = ''; inpFoto.required = true; }
    });
  });

  // Editar
  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      if (!form) return;

      const action = btn.getAttribute('data-action');
      form.action = action || form.action;
      if (methodHolder) methodHolder.innerHTML = '<input type="hidden" name="_method" value="PUT">';

      if (inpTitle) inpTitle.value = btn.getAttribute('data-title') || '';
      if (inpStart) inpStart.value = btn.getAttribute('data-start') || '';
      if (inpEnd)   inpEnd.value   = btn.getAttribute('data-end')   || '';
      if (inpActive) inpActive.checked = btn.getAttribute('data-active') === '1';

      if (previewNueva) previewNueva.src = btn.getAttribute('data-foto') || previewNueva.dataset?.default || previewNueva.src;
      if (inpFoto) { inpFoto.value = ''; inpFoto.required = false; }

      modal && modal.show();
    });
  });

  // Preview nueva imagen (al seleccionar archivo)
  if (inpFoto && previewNueva) {
    inpFoto.addEventListener('change', (e) => {
      const file = e.target.files?.[0];
      if (!file) return;
      previewNueva.src = URL.createObjectURL(file);
    });
  }

  // Abrir modal de imagen (clic en miniatura o boton Ver)
  function openPreview(src) {
    if (previewTarget && src) {
      previewTarget.src = src;
      modalPrev && modalPrev.show();
    }
  }

  document.querySelectorAll('.img-thumb').forEach(img =>
    img.addEventListener('click', () => openPreview(img.getAttribute('data-foto') || img.src))
  );

  document.querySelectorAll('.btn-view').forEach(btn =>
    btn.addEventListener('click', () => openPreview(btn.getAttribute('data-foto')))
  );

  // Eliminar con SweetAlert2
  document.querySelectorAll('.btn-delete').forEach((btn) => {
    btn.addEventListener('click', async () => {
      const id = btn.getAttribute('data-id');
      const name = btn.getAttribute('data-name') || 'Popup';
      const url = btn.getAttribute('data-url');

      if (!url) return;

      const swal = await Swal.fire({
        title: 'Eliminar',
        html: `<div class="text-start">Vas a eliminar <b>${name}</b>. Esta accion no se puede deshacer.</div>`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Si, eliminar',
        cancelButtonText: 'Cancelar',
        reverseButtons: true,
        focusCancel: true,
        customClass: {
          confirmButton: 'btn btn-danger',
          cancelButton: 'btn btn-outline-secondary ms-2'
        },
        buttonsStyling: false
      });

      if (!swal.isConfirmed) return;

      const formId = `del-form-${id}`;
      const delForm = document.getElementById(formId);
      if (delForm) {
        delForm.submit();
        return;
      }

      // Fallback AJAX
      setBtnLoading(btn, true);
      try {
        const res = await fetch(url, {
          method: 'POST',
          headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': getCsrfToken(),
            'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
          },
          body: new URLSearchParams({ _method: 'DELETE' })
        });
        if (!res.ok) throw new Error('HTTP ' + res.status);

        await Swal.fire({ icon: 'success', title: 'Eliminado', text: 'El registro fue eliminado.', timer: 1200, showConfirmButton: false });
        window.location.reload();
      } catch (err) {
        console.error(err);
        setBtnLoading(btn, false);
        Swal.fire({ icon: 'error', title: 'Error', text: 'No se pudo eliminar. Intenta de nuevo.' });
      }
    });
  });
});
