// public/js/admin/admision_matricula/matricula/requisitos/matri-requisitos.js
document.addEventListener('DOMContentLoaded', () => {
  // ====== Modales y formularios ======
  const editModalEl = document.querySelector('#modalEditar');
  const editModal   = editModalEl ? new bootstrap.Modal(editModalEl) : null;

  const formEdit       = document.getElementById('formEditar');
  const eNroPaso       = document.getElementById('editNroPaso');
  const eTitulo        = document.getElementById('editTitulo');
  const eDescripcion   = document.getElementById('editDescripcion');
  const eIcono         = document.getElementById('editIcono');
  const eActive        = document.getElementById('editActive');

  // ====== EDITAR ======
  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id          = btn.dataset.id;
      const nroPaso     = btn.dataset.nroPaso || '1';               // <-- data-nro-paso => dataset.nroPaso
      const titulo      = btn.dataset.titulo || '';
      const descripcion = btn.dataset.descripcion || '';
      const icono       = btn.dataset.icono || '';
      const active      = parseInt(btn.dataset.active, 10) === 1;

      if (eNroPaso)     eNroPaso.value = nroPaso;
      if (eTitulo)      eTitulo.value = titulo;
      if (eDescripcion) eDescripcion.value = descripcion;
      if (eIcono)       eIcono.value = icono;
      if (eActive)      eActive.checked = active;

      // Usamos la URL completa que viene del Blade
      let url = btn.dataset.updateUrl;

      // Fallback opcional: si definiste en el Blade, antes de cargar este JS:
      // <script>window.MATRI_REQ_BASE = "{{ url('/admin/matricula/requisitos') }}/";</script>
      if (!url && window.MATRI_REQ_BASE) url = String(window.MATRI_REQ_BASE) + id;

      if (!url) {
        console.error('No se pudo resolver la URL de actualizacin: falta data-update-url o MATRI_REQ_BASE.');
        return;
      }

      if (formEdit) formEdit.action = url; // PUT /admin/matricula/requisitos/{id}
      if (editModal) editModal.show();
    });
  });

  // ====== ELIMINAR ======
  const formDelete = document.getElementById('formEliminar');
  const delTitulo  = document.getElementById('delTitulo');

  // Al abrir el modal (click en el botn), seteamos la action con /{id}
  document.addEventListener('click', (e) => {
    const btn = e.target.closest('.btn-delete');
    if (!btn) return;

    const url   = btn.getAttribute('data-url') || '';
    const title = btn.getAttribute('data-title') || 'este registro';

    if (!url) {
      console.error('El botn de eliminar no tiene data-url con la ruta DELETE.');
      return;
    }

    if (formDelete) formDelete.setAttribute('action', url); // DELETE /admin/matricula/requisitos/{id}
    if (delTitulo)  delTitulo.textContent = title;
  });

  // ====== Paginacin (con fallback de selector) ======
  let tableBody = document.querySelector('.matri-requisitos-table tbody');
  if (!tableBody) tableBody = document.querySelector('.content-table tbody'); // fallback a tu clase actual

  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(row => !row.classList.contains('no-data') && row.children.length > 3);
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(Math.max(dataRows.length, 1) / pageSize);

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end   = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(row => tableBody.appendChild(row));
      if (pageRows.length === 0) {
        const noDataRow = document.createElement('tr');
        noDataRow.innerHTML = '<td colspan="6" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(noDataRow);
      }
    }

    function createPagination() {
      const table = tableBody.closest('table');
      const host  = table ? table.parentElement : tableBody.parentElement;

      host.querySelectorAll('.matri-requisitos-pagination').forEach(p => p.remove());

      const pagination = document.createElement('nav');
      pagination.className = 'matri-requisitos-pagination mt-3';

      const prevDisabled = currentPage === 1 ? ' disabled' : '';
      const nextDisabled = currentPage === totalPages ? ' disabled' : '';

      pagination.innerHTML = `<ul class="pagination justify-content-end">
        <li class="page-item${prevDisabled}">
          <a class="page-link" href="#" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a>
        </li>
        ${Array.from({ length: totalPages }, (_, i) =>
          `<li class="page-item${i + 1 === currentPage ? ' active' : ''}">
             <a class="page-link" href="#">${i + 1}</a>
           </li>`
        ).join('')}
        <li class="page-item${nextDisabled}">
          <a class="page-link" href="#" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a>
        </li>
      </ul>`;

      host.appendChild(pagination);

      const pageLinks = pagination.querySelectorAll('.page-link');

      // 00
      pageLinks[0].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage > 1) {
          currentPage--;
          renderPage(currentPage);
          createPagination();
        }
      });

      // 1..N
      pageLinks.forEach((link, idx) => {
        if (idx > 0 && idx < totalPages + 1) {
          link.addEventListener('click', e => {
            e.preventDefault();
            currentPage = idx;
            renderPage(currentPage);
            createPagination();
          });
        }
      });

      // 03
      pageLinks[totalPages + 1].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage < totalPages) {
          currentPage++;
          renderPage(currentPage);
          createPagination();
        }
      });
    }

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }

  // Si quieres reabrir modal Nuevo tras validacin:
  if (window.matriRequisitosShowNuevoModal) {
    const nuevo = document.querySelector('#modalNuevo');
    if (nuevo) new bootstrap.Modal(nuevo).show();
  }
});