// public/js/.../matri-detalle-requisitos.js
document.addEventListener('DOMContentLoaded', () => {
  // ====== Modales / forms ======
  const editModalEl = document.querySelector('#modalEditar');
  const editModal   = editModalEl ? new bootstrap.Modal(editModalEl) : null;

  const formEdit = document.getElementById('formEditar');
  const eReq     = document.getElementById('editReq');
  const eDesc    = document.getElementById('editDescripcion');
  const eActive  = document.getElementById('editActive');

  // ====== EDITAR ======
  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id    = btn.dataset.id;
      const req   = btn.dataset.req || '';
      const desc  = btn.dataset.descripcion || '';
      const act   = parseInt(btn.dataset.active, 10) === 1;

      if (eReq)    eReq.value = req;
      if (eDesc)   eDesc.value = desc;
      if (eActive) eActive.checked = act;

      // URL PUT correcta: usar la que viene del Blade
      let url = btn.dataset.updateUrl;

      // Fallback (OPCIONAL): define en Blade antes de este script:
      // <script>window.MATRI_DETALLE_BASE = "{{ url('/admin/matricula/detalle-requisitos') }}/";</script>
      if (!url && window.MATRI_DETALLE_BASE) url = String(window.MATRI_DETALLE_BASE) + id;

      if (!url) {
        console.error('Falta data-update-url o MATRI_DETALLE_BASE para armar la URL de actualizacin.');
        return;
      }

      if (formEdit) formEdit.action = url; // PUT /admin/matricula/detalle-requisitos/{id}
      if (editModal) editModal.show();
    });
  });

  // ====== ELIMINAR ======
  const formDelete = document.getElementById('formEliminar');
  const delTitulo  = document.getElementById('delTitulo');

  document.addEventListener('click', (e) => {
    const btn = e.target.closest('.btn-delete');
    if (!btn) return;

    const url   = btn.getAttribute('data-url') || '';
    const title = btn.getAttribute('data-title') || 'este registro';

    if (!url) {
      console.error('El botn de eliminar no tiene data-url.');
      return;
    }

    if (formDelete) formDelete.setAttribute('action', url); // DELETE /admin/matricula/detalle-requisitos/{id}
    if (delTitulo)  delTitulo.textContent = title;
  });

  // ====== Paginacin (con fallback de selector) ======
  let tableBody = document.querySelector('.matri-detalle-requisitos-table tbody');
  if (!tableBody) tableBody = document.querySelector('.content-table tbody');

  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(r => !r.classList.contains('no-data') && r.children.length > 3);
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(Math.max(dataRows.length, 1) / pageSize);

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end   = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(r => tableBody.appendChild(r));
      if (pageRows.length === 0) {
        const tr = document.createElement('tr');
        tr.innerHTML = '<td colspan="5" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(tr);
      }
    }

    function createPagination() {
      const table = tableBody.closest('table');
      const host  = table ? table.parentElement : tableBody.parentElement;

      host.querySelectorAll('.matri-detalle-requisitos-pagination').forEach(p => p.remove());

      const nav = document.createElement('nav');
      nav.className = 'matri-detalle-requisitos-pagination mt-3';

      const prevDisabled = currentPage === 1 ? ' disabled' : '';
      const nextDisabled = currentPage === totalPages ? ' disabled' : '';

      nav.innerHTML = `<ul class="pagination justify-content-end">
        <li class="page-item${prevDisabled}">
          <a class="page-link" href="#" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a>
        </li>
        ${Array.from({ length: totalPages }, (_, i) =>
          `<li class="page-item${i + 1 === currentPage ? ' active' : ''}">
             <a class="page-link" href="#">${i + 1}</a>
           </li>`
        ).join('')}
        <li class="page-item${nextDisabled}">
          <a class="page-link" href="#" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a>
        </li>
      </ul>`;

      host.appendChild(nav);

      const links = nav.querySelectorAll('.page-link');

      // 00
      links[0].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage > 1) { currentPage--; renderPage(currentPage); createPagination(); }
      });

      // 1..N
      links.forEach((a, idx) => {
        if (idx > 0 && idx < totalPages + 1) {
          a.addEventListener('click', e => {
            e.preventDefault();
            currentPage = idx;
            renderPage(currentPage);
            createPagination();
          });
        }
      });

      // 03
      links[totalPages + 1].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage < totalPages) { currentPage++; renderPage(currentPage); createPagination(); }
      });
    }

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }

  // Reabrir modal Nuevo si hubo validacin fallida
  if (window.matriDetalleRequisitosShowNuevoModal) {
    const nuevo = document.querySelector('#modalNuevo');
    if (nuevo) new bootstrap.Modal(nuevo).show();
  }
});