// public/js/admin/admision_matricula/beca/tipo/beca-tipo.js
document.addEventListener('DOMContentLoaded', () => {
  // ====== Editar ======
  const editModalEl = document.getElementById('modalEditar');
  const editModal   = editModalEl ? new bootstrap.Modal(editModalEl) : null;

  const formEdit    = document.getElementById('formEditar');
  const eTitulo     = document.getElementById('editTitulo');
  const eDesc       = document.getElementById('editDescripcion');
  const eReq        = document.getElementById('editRequisito');
  const eIcono      = document.getElementById('editIcono');
  const eActive     = document.getElementById('editActive');
  const ePeriodo    = document.getElementById('editPeriodo'); // NUEVO

  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id   = btn.dataset.id;
      const tpl  = formEdit?.dataset.actionTemplate || '';
      let url    = tpl ? tpl.replace('__ID__', id) : null;

      if (!url && window.BECA_TIPO_BASE) url = String(window.BECA_TIPO_BASE) + id;
      if (!url) {
        console.error('No se pudo construir la URL de actualizacin (falta data-action-template o BECA_TIPO_BASE).');
        return;
      }

      if (eTitulo) eTitulo.value   = btn.dataset.titulo || '';
      if (eDesc)   eDesc.value     = btn.dataset.descripcion || '';
      if (eReq)    eReq.value      = btn.dataset.requisito || '';
      if (eIcono)  eIcono.value    = btn.dataset.icono || '';
      if (eActive) eActive.checked = parseInt(btn.dataset.active, 10) === 1;
      if (ePeriodo) ePeriodo.value = btn.dataset.periodo || ''; // NUEVO

      if (formEdit) formEdit.action = url;
      if (editModal) editModal.show();
    });
  });

  // ====== Eliminar ======
  const formDelete = document.getElementById('formEliminar');
  const delTitulo  = document.getElementById('delTitulo');

  document.addEventListener('click', (e) => {
    const btn = e.target.closest('.btn-delete');
    if (!btn) return;

    const url   = btn.getAttribute('data-url') || '';
    const title = btn.getAttribute('data-title') || 'este registro';

    if (!url) {
      console.error('El botn de eliminar no tiene data-url con la ruta DELETE.');
      return;
    }

    if (formDelete) formDelete.setAttribute('action', url);
    if (delTitulo)  delTitulo.textContent = title;
  });

  // ====== Paginacin simple ======
  let tableBody = document.querySelector('.beca-tipo-table tbody');
  if (!tableBody) tableBody = document.querySelector('.content-table tbody');

  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(r => !r.classList.contains('no-data') && r.children.length > 3);
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(Math.max(dataRows.length, 1) / pageSize);

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end   = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(r => tableBody.appendChild(r));
      if (pageRows.length === 0) {
        const tr = document.createElement('tr');
        tr.innerHTML = '<td colspan="7" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(tr);
      }
    }

    function createPagination() {
      const table = tableBody.closest('table');
      const host  = table ? table.parentElement : tableBody.parentElement;

      host.querySelectorAll('.beca-tipo-pagination').forEach(p => p.remove());

      const nav = document.createElement('nav');
      nav.className = 'beca-tipo-pagination mt-3';

      const prevDisabled = currentPage === 1 ? ' disabled' : '';
      const nextDisabled = currentPage === totalPages ? ' disabled' : '';

      nav.innerHTML = `<ul class="pagination justify-content-end">
        <li class="page-item${prevDisabled}">
          <a class="page-link" href="#" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a>
        </li>
        ${Array.from({ length: totalPages }, (_, i) =>
          `<li class="page-item${i + 1 === currentPage ? ' active' : ''}">
             <a class="page-link" href="#">${i + 1}</a>
           </li>`
        ).join('')}
        <li class="page-item${nextDisabled}">
          <a class="page-link" href="#" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a>
        </li>
      </ul>`;

      host.appendChild(nav);

      const links = nav.querySelectorAll('.page-link');

      // 00 anterior
      links[0].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage > 1) {
          currentPage--;
          renderPage(currentPage);
          createPagination();
        }
      });

      // Nmeros
      links.forEach((a, idx) => {
        if (idx > 0 && idx < totalPages + 1) {
          a.addEventListener('click', e => {
            e.preventDefault();
            currentPage = idx;
            renderPage(currentPage);
            createPagination();
          });
        }
      });

      // 03 siguiente
      links[totalPages + 1].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage < totalPages) {
          currentPage++;
          renderPage(currentPage);
          createPagination();
        }
      });
    }

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }

  // ====== Reabrir modal "Nuevo" si hubo errores de validacin en store ======
  if (window.becaTipoShowNuevoModal) {
    const nuevo = document.querySelector('#modalNuevo');
    if (nuevo) new bootstrap.Modal(nuevo).show();
  }
});
