document.addEventListener('DOMContentLoaded', () => {
  // ========== EDITAR ==========
  const editModal = new bootstrap.Modal('#modalEditar');
  const formEdit  = document.getElementById('formEditar');
  const eTipo     = document.getElementById('editTipo');
  const eTitulo   = document.getElementById('editTitulo');
  const eDesc     = document.getElementById('editDescripcion');
  const eActive   = document.getElementById('editActive');

  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const tipo = btn.dataset.tipo;
      const tit  = btn.dataset.titulo || '';
      const desc = btn.dataset.descripcion || '';
      const act  = parseInt(btn.dataset.active, 10) === 1;
      const updateUrl = btn.dataset.update;

      eTipo.value = tipo;
      eTitulo.value = tit;
      eDesc.value = desc;
      eActive.checked = act;

      formEdit.action = updateUrl;
      editModal.show();
    });
  });

  // ========== ELIMINAR (SweetAlert2 + form global) ==========
  document.addEventListener('click', async (ev) => {
    const btn = ev.target.closest('.btn-delete');
    if (!btn) return;

    const action = btn.getAttribute('data-action');
    const title  = btn.getAttribute('data-title') || 'este requisito';

    if (!action) {
      console.error('[Eliminar] Falta data-action (URL) en el botn.');
      return;
    }

    const result = await Swal.fire({
      title: 'Eliminar?',
      html: `<div class="text-muted">Vas a eliminar <strong>${title}</strong>.</div>`,
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Si, eliminar',
      cancelButtonText: 'Cancelar',
      reverseButtons: true,
      focusCancel: true,
      confirmButtonColor: '#dc3545',
      cancelButtonColor: '#6c757d',
      customClass: {
        popup: 'shadow rounded-3'
      }
    });

    if (result.isConfirmed) {
      // Mostrar loading breve (visual)
      Swal.fire({
        title: 'Eliminando',
        allowOutsideClick: false,
        allowEscapeKey: false,
        didOpen: () => Swal.showLoading()
      });

      const form = document.getElementById('globalDeleteForm');
      if (!form) {
        console.error('[Eliminar] No se encontr #globalDeleteForm.');
        Swal.close();
        return;
      }

      form.action = action;  // admin-requisitos.destroy/{id}
      form.submit();         // redirige; si tu controlador setea session('success'), se ver la alerta bootstrap
    }
  });

  // ========== PAGINACI07N ==========
  const tableBody = document.querySelector('.content-table tbody');
  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(r => r.querySelector('td'));
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(dataRows.length / pageSize);

    const renderPage = page => {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(r => tableBody.appendChild(r));
      if (pageRows.length === 0) {
        const noDataRow = document.createElement('tr');
        noDataRow.innerHTML = '<td colspan="5" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(noDataRow);
      }
    };

    const createPagination = () => {
      let pagination = document.querySelector('.requisitos-pagination');
      if (pagination) pagination.remove();
      pagination = document.createElement('nav');
      pagination.className = 'requisitos-pagination mt-3';
      pagination.innerHTML = `<ul class="pagination justify-content-end">
        ${Array.from({ length: totalPages }, (_, i) =>
          `<li class="page-item ${i + 1 === currentPage ? 'active' : ''}">
            <a class="page-link" href="#">${i + 1}</a>
          </li>`).join('')}
      </ul>`;
      tableBody.parentElement.appendChild(pagination);
      pagination.querySelectorAll('.page-link').forEach((link, i) => {
        link.addEventListener('click', e => {
          e.preventDefault();
          currentPage = i + 1;
          renderPage(currentPage);
          createPagination();
        });
      });
    };

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }

  // Mostrar modalNuevo si hubo error en create
  if (window.showModalNuevoOnError) {
    new bootstrap.Modal('#modalNuevo').show();
  }
});
