document.addEventListener('DOMContentLoaded', () => {
  // ====== Preview icono en "Nuevo" ======
  const createIconSelect = document.getElementById('createIcono');
  const createIconPreview = document.getElementById('createIconPreview');
  if (createIconSelect && createIconPreview) {
    createIconSelect.addEventListener('change', () => {
      createIconPreview.innerHTML = `<i class="${createIconSelect.value}"></i>`;
    });
  }

  // ====== Editar ======
  const editModal = new window.bootstrap.Modal(document.getElementById('modalEditar'));
  const formEdit  = document.getElementById('formEditar');
  const eTitulo   = document.getElementById('editTitulo');
  const eDesc     = document.getElementById('editDescripcion');
  const eIcon     = document.getElementById('editIcono');
  const eIconPrev = document.getElementById('editIconPreview');
  const eActive   = document.getElementById('editActive');

  if (eIcon && eIconPrev) {
    eIcon.addEventListener('change', () => {
      eIconPrev.innerHTML = `<i class="${eIcon.value}"></i>`;
    });
  }

  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const titulo = btn.dataset.titulo || '';
      const desc   = btn.dataset.descripcion || '';
      const icono  = btn.dataset.icono || '';
      const act    = parseInt(btn.dataset.active, 10) === 1;

      if (eTitulo) eTitulo.value = titulo;
      if (eDesc)   eDesc.value   = desc;
      if (eIcon)   eIcon.value   = icono;
      if (eIconPrev) eIconPrev.innerHTML = icono ? `<i class="${icono}"></i>` : '<i class="fa-regular fa-circle-question"></i>';
      if (eActive) eActive.checked = act;

      if (formEdit) {
        formEdit.action = btn.dataset.update; // URL completa desde data-update
        editModal.show();
      }
    });
  });

  // ====== Paginacin ======
  const tableBody = document.querySelector('.content-table tbody');
  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(row => !row.classList.contains('no-data') && row.children.length > 3);
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(dataRows.length / pageSize);

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(row => tableBody.appendChild(row));
      if (pageRows.length === 0) {
        const noDataRow = document.createElement('tr');
        noDataRow.innerHTML = '<td colspan="5" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(noDataRow);
      }
    }

    function createPagination() {
      let pagination = document.querySelector('.modalidades-pagination');
      if (pagination) pagination.remove();
      pagination = document.createElement('nav');
      pagination.className = 'modalidades-pagination mt-3';
      let prevDisabled = currentPage === 1 ? ' disabled' : '';
      let nextDisabled = currentPage === totalPages ? ' disabled' : '';
      pagination.innerHTML = `<ul class="pagination justify-content-end">
        <li class="page-item${prevDisabled}"><a class="page-link" href="#" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a></li>
        ${Array.from({ length: totalPages }, (_, i) => `<li class="page-item${i+1===currentPage?' active':''}"><a class="page-link" href="#">${i+1}</a></li>`).join('')}
        <li class="page-item${nextDisabled}"><a class="page-link" href="#" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a></li>
      </ul>`;
      const table = tableBody.closest('table');
      if (table) {
        table.parentElement.querySelectorAll('.modalidades-pagination').forEach(p => p.remove());
        table.parentElement.appendChild(pagination);
      } else {
        tableBody.parentElement.appendChild(pagination);
      }
      const pageLinks = pagination.querySelectorAll('.page-link');
      pageLinks[0].addEventListener('click', (e) => {
        e.preventDefault();
        if (currentPage > 1) { currentPage--; renderPage(currentPage); createPagination(); }
      });
      pageLinks.forEach((link, idx) => {
        if (idx > 0 && idx < totalPages + 1) {
          link.addEventListener('click', (e) => {
            e.preventDefault();
            currentPage = idx; renderPage(currentPage); createPagination();
          });
        }
      });
      pageLinks[totalPages + 1].addEventListener('click', (e) => {
        e.preventDefault();
        if (currentPage < totalPages) { currentPage++; renderPage(currentPage); createPagination(); }
      });
    }
    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }

  // ====== ELIMINAR: usar eventos del modal para evitar el error aria-hidden ======
  const modalEliminar = document.getElementById('modalEliminar');
  const btnConfirm    = document.getElementById('btnConfirmDelete');
  const delTitle      = document.getElementById('delTitulo');

  let formIdToSubmit = null; // id del form oculto de la fila (ej: "del-form-12")

  // 1) Antes de mostrar el modal, toma los datos del botn que lo abri
  modalEliminar.addEventListener('show.bs.modal', (event) => {
    const triggerBtn = event.relatedTarget; // botn .btn-delete que abri el modal
    formIdToSubmit = triggerBtn?.dataset?.form || null;
    const title = triggerBtn?.dataset?.title || 'esta modalidad';
    if (delTitle) delTitle.textContent = title;
  });

  // 2) Cuando ya es visible, enfocamos el botn confirmar (ya no hay aria-hidden)
  modalEliminar.addEventListener('shown.bs.modal', () => {
    btnConfirm?.focus();
  });

  // 3) Al cerrar, limpiamos estado y UI
  modalEliminar.addEventListener('hidden.bs.modal', () => {
    formIdToSubmit = null;
    if (btnConfirm) {
      btnConfirm.disabled = false;
      btnConfirm.textContent = 'S, eliminar';
    }
  });

  // 4) Confirmar  submit del form oculto (DELETE real a /modalidades/{id})
  if (btnConfirm) {
    btnConfirm.addEventListener('click', () => {
      if (!formIdToSubmit) return;
      const form = document.getElementById(formIdToSubmit);
      if (!form) return;

      btnConfirm.disabled = true;
      btnConfirm.textContent = 'Eliminando...';
      form.submit();
    });
  }

  // Mostrar modal "Nuevo" si viene de create con errores (opcional)
  if (window.adminModalidadesShowNuevoModal) {
    new window.bootstrap.Modal(document.getElementById('modalNuevo')).show();
  }
});
