<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Slider extends Model
{
    use SoftDeletes;

    // tu patrón: tablas en singular
    protected $table = 'slider';

    protected $fillable = ['foto', 'is_active'];

    protected $casts = ['is_active' => 'boolean'];

    public function getImageUrlAttribute(): string
    {
        return asset('public/images/' . ltrim($this->foto, '/'));
    }
}
