<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Popup extends Model
{
    use SoftDeletes;

    // Tu tabla es singular
    protected $table = 'popup';

    protected $fillable = [
        'title',
        'image',
        'is_active',
        'start_datetime',
        'end_datetime',
    ];

    protected $casts = [
        'is_active'      => 'boolean',
        'start_datetime' => 'datetime',
        'end_datetime'   => 'datetime',
    ];

    // URL absoluta de la imagen
    public function getImageUrlAttribute()
    {
        return asset('images/' . ltrim($this->image, '/'));
    }

    /**
     * Scope: solo activos y dentro de la ventana de tiempo.
     * - si start_datetime es NULL, no hay inicio lmite
     * - si end_datetime   es NULL, no hay fin lmite
     */
    public function scopePublished($q)
    {
        $now = now();
        return $q->where('is_active', true)
                ->where(function ($qq) use ($now) {
                    $qq->whereNull('start_datetime')
                       ->orWhere('start_datetime', '<=', $now);
                })
                ->where(function ($qq) use ($now) {
                    $qq->whereNull('end_datetime')
                       ->orWhere('end_datetime', '>=', $now);
                });
    }
}
