<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Slider;
use Illuminate\Http\Request;

class SliderController extends Controller
{
    public function index()
    {
        $items = Slider::orderBy('id', 'asc')->get();
        return view('admin.inicio.slider.index', compact('items'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'foto'      => ['required','image','mimes:jpg,jpeg,png,webp','max:4096'],
            'is_active' => ['nullable','boolean'],
        ]);

        $dest = public_path('images/sliders');
        if (!is_dir($dest)) { @mkdir($dest, 0775, true); }

        $name = time() . '_' . preg_replace('/\s+/', '_', $request->file('foto')->getClientOriginalName());
        $request->file('foto')->move($dest, $name);

        Slider::create([
            'foto'      => 'sliders/' . $name,
            'is_active' => $request->boolean('is_active', true),
        ]);

        return back()->with('success', 'Imagen añadida al slider.');
    }

    public function update(Request $request, Slider $slider)
    {
        $request->validate([
            'foto'      => ['nullable','image','mimes:jpg,jpeg,png,webp','max:4096'],
            'is_active' => ['nullable','boolean'],
        ]);

        $slider->is_active = $request->boolean('is_active', true);

        if ($request->hasFile('foto')) {
            // eliminar anterior
            $oldPath = public_path('images/' . $slider->foto);
            if (is_file($oldPath)) @unlink($oldPath);

            $dest = public_path('images/sliders');
            if (!is_dir($dest)) { @mkdir($dest, 0775, true); }

            $name = time() . '_' . preg_replace('/\s+/', '_', $request->file('foto')->getClientOriginalName());
            $request->file('foto')->move($dest, $name);

            $slider->foto = 'sliders/' . $name;
        }

        $slider->save();
        return back()->with('success', 'Imagen actualizada.');
    }

    public function destroy(Slider $slider)
    {
        $file = public_path('images/' . $slider->foto);
        if (is_file($file)) @unlink($file);

        $slider->delete();
        return back()->with('success', 'Imagen eliminada.');
    }
}
