<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\MensajeContacto;
use Illuminate\Http\Request;

class MensajesContactoController extends Controller
{
    public function index()
    {
        $items = MensajeContacto::orderByDesc('id')->get();
        return view('admin.contactanos.mensajes_contacto.index', compact('items'));
    }

    public function destroy($id)
    {
        $mensaje = MensajeContacto::findOrFail($id);
        $mensaje->delete();

        return redirect()
            ->back()
            ->with('success', 'Mensaje eliminado correctamente.');
    }
}
