<?php

namespace App\Http\Controllers;

use Barryvdh\DomPDF\Facade\Pdf;

use App\Models\ProgramasEstudio;
use Illuminate\Support\Str;

class ProgramaController extends Controller
{
    public function show(?string $programa = null)
    {
        $base = ProgramasEstudio::activos()
            ->with([
                'info',
                'perfil',
                'coordinadores' => fn($q) => $q->where('is_active', 1)->orderBy('id'),
                'areas'         => fn($q) => $q->where('is_active', 1)->orderBy('id'),
                'egresados'     => fn($q) => $q->where('is_active', 1)->orderBy('id'),
                'modulosMalla'  => fn($q) => $q->active()->orderBy('id'),
                'modulosMalla.semestres' => fn($q) => $q->active()->orderBy('id'),
                'modulosMalla.semestres.cursos' => fn($q) => $q->active()->orderBy('id'),
                'convenios'     => fn($q) => $q->active()->orderBy('id'),
                'galerias'      => fn($q) => $q->active()->latest('id')->take(6),
            ])
            ->orderBy('id')
            ->get();

        $programa = $base->first(function ($p) use ($programa) {
            return Str::slug($p->nombre, '_') === $programa;
        });

        abort_unless($programa, 404);

        return view('programas.programas_estudio', compact('programa'));
    }


    
    
      public function mallaPdf(int $programaId)
    {
        $programa = ProgramasEstudio::activos()
            ->with([
                'info',
                'modulosMalla'  => fn($q) => $q->active()->orderBy('id'),
                'modulosMalla.semestres' => fn($q) => $q->active()->orderBy('id'),
                'modulosMalla.semestres.cursos' => fn($q) => $q->active()->orderBy('id'),
            ])->findOrFail($programaId);

        // Aplanar semestres
        $semestres = collect();
        foreach ($programa->modulosMalla ?? [] as $mod) {
            foreach ($mod->semestres ?? [] as $sem) {
                $semestres->push($sem);
            }
        }

        // 1) Renderizar Blade a HTML
        $html = view('programas.pdf.malla', compact('programa', 'semestres'))->render();

        // 2) Normalizar a UTF-8 y evitar autodetección problemática
        // Limpia bytes inválidos (si llegan desde BD o archivos)
        $html = iconv('UTF-8', 'UTF-8//IGNORE', $html);
        // Convierte a entidades HTML (DomPDF lo digiere mejor que 'auto')
        $html = mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8');

        // 3) Opciones DomPDF (logo remoto y fuente con tildes)
        $pdf = Pdf::setOptions([
                'isHtml5ParserEnabled' => true,
                'isRemoteEnabled'      => true,       // por la URL del logo
                'defaultFont'          => 'DejaVu Sans',
            ])
            ->loadHTML($html)
            ->setPaper('a4', 'portrait');

        // Nombre de archivo
        $slug = $programa->slug ?? Str::slug($programa->nombre);
        $filename = "Malla_{$slug}.pdf";

        return $pdf->download($filename);
    }
    
    
    
    
    
    
    
    
    
}
