<?php

namespace App\Http\Controllers\Portal;

use App\Http\Controllers\Controller;
use App\Models\Popup;

class PopupPublicController extends Controller
{
    // partial Blade para incluir en el portal
    public function blade()
    {
        $activos = Popup::published()->orderBy('start_datetime')->get();
        return view('portal.popups.activos', compact('activos'));
    }

    // JSON (opcional)
    public function json()
    {
        $activos = Popup::published()->orderBy('start_datetime')->get([
            'id','title','image','start_datetime','end_datetime'
        ]);

        return response()->json([
            'now'   => now()->toIso8601String(),
            'items' => $activos->map(function($p){
                return [
                    'id'    => $p->id,
                    'title' => $p->title,
                    'image' => asset('images/'.$p->image),
                    'start' => optional($p->start_datetime)->toIso8601String(),
                    'end'   => optional($p->end_datetime)->toIso8601String(),
                ];
            }),
        ]);
    }
}
