<?php

namespace App\Http\Controllers;

use App\Models\MatriculaCronograma;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;

class MatriculaCronogramaController extends Controller
{
    /** Opciones de iconos para el combo (label => value) */
    private array $iconOptions = [
        'Calendario' => 'fa-solid fa-calendar',
        'Usuarios'   => 'fa-solid fa-users',
        'Reloj'      => 'fa-solid fa-clock',
        'Play'       => 'fa-solid fa-play',
        'Lista'      => 'fa-solid fa-list',
        'Check'      => 'fa-solid fa-check',
        'Estrella'   => 'fa-solid fa-star',
        'Libro'      => 'fa-solid fa-book',
    ];

    public function index()
    {
        $items = MatriculaCronograma::orderBy('id', 'asc')->get();
        $iconOptions = $this->iconOptions;

        return view('admin.admision_matricula.matricula.cronograma.index', compact('items','iconOptions'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'titulo'      => ['required','string','max:200'],
            // si la columna en BD es DATE o DATETIME
            'fecha'       => ['required','date'], // o: ['required','date_format:Y-m-d']
            'descripcion' => ['required','string','max:255'],
            'icono'       => ['required','string','max:100'],
            'is_active'   => ['nullable','boolean'],
        ]);
    
        // Normaliza a Y-m-d (si la columna es DATE) o a Y-m-d H:i:s (si es DATETIME)
        $fecha = Carbon::parse($data['fecha'])->format('Y-m-d'); // o 'Y-m-d H:i:s'
    
        MatriculaCronograma::create([
            'titulo'      => $data['titulo'],
            'fecha'       => $fecha,
            'descripcion' => $data['descripcion'],
            'icono'       => $data['icono'],
            'is_active'   => $request->boolean('is_active'),
        ]);
    
        return redirect()->route('matri-cronograma.index')->with('success', 'Registro creado.');
    }

    public function update(Request $request, MatriculaCronograma $cronograma)
    {
        $data = $request->validate([
            'titulo'      => ['required','string','max:200'],
            'fecha'       => ['required','date'], // o 'date_format:Y-m-d'
            'descripcion' => ['required','string','max:255'],
            'icono'       => ['required','string','max:100'],
            'is_active'   => ['nullable','boolean'],
        ]);
    
        $fecha = Carbon::parse($data['fecha'])->format('Y-m-d'); // o 'Y-m-d H:i:s'
    
        $cronograma->update([
            'titulo'      => $data['titulo'],
            'fecha'       => $fecha,
            'descripcion' => $data['descripcion'],
            'icono'       => $data['icono'],
            'is_active'   => $request->boolean('is_active'),
        ]);
    
        return redirect()->route('matri-cronograma.index')->with('success', 'Registro actualizado.');
    }

    public function destroy(MatriculaCronograma $cronograma)
    {
        $cronograma->delete(); // Soft delete
        return redirect()->route('matri-cronograma.index')->with('success', 'Registro eliminado.');
    }
}
