<?php

namespace App\Http\Controllers;

use App\Models\BecaTipo;
use App\Models\BecaBeneficiario;
use App\Models\BecaProceso;
use App\Models\PeriodoAcademico;
use Illuminate\Support\Facades\DB;

class BecasController extends Controller
{
    public function index()
    {
        // Tipos de beca
        $becas = BecaTipo::activos()
            ->with('periodoAcademico:id,nombre')
            ->orderBy('id') // <= sin 'orden', ordena por id
            ->get([
                'periodo_academico_id',
                'titulo',
                'descripcion',
                'icono',
                DB::raw('requisito as badge'), // 'badge' no existe; mapeamos 'requisito'
            ])
            ->groupBy(fn($b) => $b->periodoAcademico?->nombre ?? 'Sin periodo');

        // Beneficiarios agrupados por programa (esto no cambia)
        $beneficiarios = BecaBeneficiario::activos()
            ->with(['programa:id,nombre', 'tipo:id,titulo,periodo_academico_id', 'tipo.periodoAcademico:id,nombre'])
            ->orderBy('programa_id')->orderBy('id')
            ->get(['programa_id', 'tipo_beca_id', 'nombre'])
            ->groupBy(fn($b) => $b->programa?->nombre ?? 'Sin programa');

        $procesos = BecaProceso::where('is_active', 1)
            ->orderBy('nro_paso')
            ->get(['nro_paso', 'titulo', 'descripcion']);

        return view('admision.becas', compact('becas', 'beneficiarios', 'procesos'));
    }
}
