<?php

namespace App\Http\Controllers;

use App\Models\BecaTipo;
use App\Models\PeriodoAcademico;
use Illuminate\Http\Request;

class BecaTipoController extends Controller
{
    /** Opciones para el combobox de iconos (label => value) */
    private array $iconOptions = [
        'Trofeo (excelencia)'        => 'fa-solid fa-trophy',
        'Corazon (inclusion)'        => 'fa-solid fa-heart',
        'Medalla (deporte)'          => 'fa-solid fa-medal',
        'Usuarios (familiar/varios)' => 'fa-solid fa-users',
        'Bombilla (innovacion)'      => 'fa-solid fa-lightbulb',
        'Mano ayudando'              => 'fa-solid fa-handshake-angle',
        'Estrella'                    => 'fa-solid fa-star',
        'Libro'                       => 'fa-solid fa-book',
        'Check'                       => 'fa-solid fa-check',
    ];
    

    public function byPeriod($periodoId)
    {
        $tipos = BecaTipo::query()
            ->where('is_active', 1)
            ->where('periodo_academico_id', $periodoId)
            ->orderBy('titulo')
            ->get(['id','titulo']);
    
        return response()->json($tipos, 200, ['Content-Type' => 'application/json']);
    }
        
    

    public function index()
    {
        $items       = BecaTipo::with('periodoAcademico')->orderBy('id', 'asc')->get();
        $iconOptions = $this->iconOptions;
        $periodos    = PeriodoAcademico::orderBy('nombre')->get();

        return view('admin.admision_matricula.beca.tipo.index', compact('items', 'iconOptions', 'periodos'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'titulo'               => ['required', 'string', 'max:200'],
            'descripcion'          => ['required', 'string', 'max:2000'],
            'requisito'            => ['required', 'string', 'max:500'],
            'icono'                => ['required', 'string', 'max:100'],
            'is_active'            => ['nullable', 'boolean'],
            'periodo_academico_id' => ['nullable', 'integer', 'exists:periodos_academicos,id'],
        ]);

        BecaTipo::create([
            'titulo'               => $data['titulo'],
            'descripcion'          => $data['descripcion'],
            'requisito'            => $data['requisito'],
            'icono'                => $data['icono'],
            'is_active'            => $request->boolean('is_active'),
            'periodo_academico_id' => $data['periodo_academico_id'] ?? null,
        ]);

        return redirect()->route('beca-tipo.index')->with('success', 'Beca creada correctamente.');
    }

    public function update(Request $request, BecaTipo $tipo)
    {
        $data = $request->validate([
            'titulo'               => ['required', 'string', 'max:200'],
            'descripcion'          => ['required', 'string', 'max:2000'],
            'requisito'            => ['required', 'string', 'max:500'],
            'icono'                => ['required', 'string', 'max:100'],
            'is_active'            => ['nullable', 'boolean'],
            'periodo_academico_id' => ['nullable', 'integer', 'exists:periodos_academicos,id'],
        ]);

        $tipo->update([
            'titulo'               => $data['titulo'],
            'descripcion'          => $data['descripcion'],
            'requisito'            => $data['requisito'],
            'icono'                => $data['icono'],
            'is_active'            => $request->boolean('is_active'),
            'periodo_academico_id' => $data['periodo_academico_id'] ?? null,
        ]);

        return redirect()->route('beca-tipo.index')->with('success', 'Beca actualizada correctamente.');
    }

    public function destroy(BecaTipo $tipo)
    {
        $tipo->delete(); // Soft delete
        return redirect()->route('beca-tipo.index')->with('success', 'Beca eliminada.');
    }
}
