<?php

namespace App\Http\Controllers\empresa;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Jpjob;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class JpjobController extends Controller
{


    public function index(Request $request)
    {
        if (Auth::guard('company')->check()) {

            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "4" ) {
                $tipoacceso = 4;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('empresa.ofertas_laborales.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        $idcompany = Auth::guard('company')->user()->id;
        
        if ($request->ajax()) {
            // query
            $data = DB::table('bt_trabajos as job')
                ->join('bt_empresas as com', 'job.jpcompany_id', '=', 'com.id')
                ->join('bt_categorias as cat', 'job.jpcategory_id', '=', 'cat.id')
                ->join('ubigeos as ubi', 'job.ubigeo_id', '=', 'ubi.id')
                ->select(
                    'job.id as idjob',
                    'job.puesto',
                    'job.vacantes',
                    'job.documento',
                    'job.tipo',
                    'job.modalidad',
                    'job.experiencia',
                    'job.fecpublicacion',
                    'job.feccierre',
                    DB::raw('DATE_FORMAT(job.fecpublicacion, "%d/%m/%Y") as fecpublicacion_format'),
                    DB::raw('DATE_FORMAT(job.feccierre, "%d/%m/%Y") as feccierre_format'),
                    'job.salariomin',
                    'job.salariomax',
                    'job.nivel_educativo',
                    'job.descripcion',
                    'job.estado',
                    'com.id as idcompany',
                    'com.nombre as nombrecompany',
                    'cat.id as idcategory',
                    'cat.nombre as nombrecategory',
                    'ubi.id as idubigeo',
                    DB::raw('SUBSTRING(ubi.id, 1, 2) as iddepartamento'),
                    'ubi.departamento',
                    DB::raw('SUBSTRING(ubi.id, 3, 2) as idprovincia'),
                    'ubi.provincia',
                    DB::raw('SUBSTRING(ubi.id, 5, 2) as iddistrito'),
                    'ubi.distrito',
                    DB::raw('CASE 
                    WHEN job.feccierre < CURDATE() THEN "0"
                    ELSE "1"
                    END as estado_actual'
                    )
                )
                ->orderBy('job.fecpublicacion', 'desc')
                ->where('com.id',$idcompany)
                ->get();
            // Datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        
        return  response()->json(["status" => false, "mensaje" => 'No se puede cargar la información']);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-documento' => 'required|file|mimes:pdf|max:2000', // Valida PDF y tamaño máximo de 2MB
        ], [
            'txt-documento.file' => 'El archivo PDF es requerido.',
            'txt-documento.mimes' => 'El archivo debe ser un PDF.',
            'txt-documento.max' => 'El tamaño del archivo no debe superar los 2000 KB.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => 'validators', "mensaje" => $validator->errors(),
            ]);
        } else {

            // nuevo objeto
            $item = new Jpjob();
            $item->jpcompany_id = Auth::guard('company')->user()->id;
            $item->jpcategory_id = $request->input('txt-categories');
            $item->puesto = $request->input('txt-puesto');
            $item->vacantes = $request->input('txt-vacantes');
            $item->tipo = $request->input('txt-tipo');
            $item->modalidad = $request->input('txt-modalidad');
            $item->experiencia = $request->input('txt-experiencia');
            $item->nivel_educativo = $request->input('txt-nivel_educativo');
            $item->fecpublicacion = $request->input('txt-fecpublicacion');
            $item->feccierre = $request->input('txt-feccierre');
            $item->salariomin = $request->input('txt-salariomin');
            $item->salariomax = $request->input('txt-salariomax');
            $item->estado = $request->input('txt-estado');
            $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
            $item->ubigeo_id = $idubigeo;
            $item->link = $request->input('txt-link');
            $item->descripcion = $request->input('descripcion');

            if($item->fecpublicacion > $item->feccierre){
                return response()->json(["status" => false, "mensaje" => 'La fecha de Publicacion es mayor a la fecha de cierre']);
            } 

            // validar guardado
            if ($item->save()) {
                
                $idjob = $item->id;
                
                // guardar documento si existe
                if ($request->hasFile('txt-documento')) {
                    $folderName =  'ofertas_laborales/' . $idjob;
                    Storage::disk('local')->makeDirectory('companies/' . $folderName);   // creamos la carpeta en el disco local
                    $archivo = $request->file('txt-documento');   // obtenemos el archivo
                    $archivo->storeAs($folderName, 'oferta_laboral-' . $idjob . '.pdf');  // guardado (ruta,nombre del archivo)
                    $filePath = $folderName . '/' . 'oferta_laboral-' . $idjob . '.pdf';  // ruta del archivo
                    $item->documento = $filePath;
                }

                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }

            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }
    }


    public function update(Request $request, $id)
    {
        $item = Jpjob::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->jpcompany_id = Auth::guard('company')->user()->id;
            $item->jpcategory_id = $request->input('txt-categories');
            $item->puesto = $request->input('txt-puesto');
            $item->vacantes = $request->input('txt-vacantes');
            $item->tipo = $request->input('txt-tipo');
            $item->modalidad = $request->input('txt-modalidad');
            $item->experiencia = $request->input('txt-experiencia');
            $item->nivel_educativo = $request->input('txt-nivel_educativo');
            $item->fecpublicacion = $request->input('txt-fecpublicacion');
            $item->feccierre = $request->input('txt-feccierre');
            $item->salariomin = $request->input('txt-salariomin');
            $item->salariomax = $request->input('txt-salariomax');
            $item->estado = $request->input('txt-estado');
            $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
            $item->ubigeo_id = $idubigeo;
            $item->link = $request->input('txt-link');
            $item->descripcion = $request->input('descripcion');
            
            if($item->fecpublicacion > $item->feccierre){
                return response()->json(["status" => false, "mensaje" => 'La fecha de Publicacion es mayor a la fecha de cierre']);
            } 
            
            // validar guardado
            if ($item->save()) {
                    
                $idjob = $item->id;
                
                // guardar documento si existe
                if ($request->hasFile('txt-documento')) {
                    $folderName =  'ofertas_laborales/' . $idjob;
                    Storage::disk('local')->makeDirectory('companies/' . $folderName);   // creamos la carpeta en el disco local
                    $archivo = $request->file('txt-documento');   // obtenemos el archivo
                    $archivo->storeAs($folderName, 'oferta_laboral-' . $idjob . '.pdf');  // guardado (ruta,nombre del archivo)
                    $filePath = $folderName . '/' . 'oferta_laboral-' . $idjob . '.pdf';  // ruta del archivo
                    $item->documento = $filePath;
                }

                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }

            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }
    }


    public function destroy($id)
    {
        $item = Jpjob::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
