<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\paggeAccess\PageAccessController;
use App\Http\Controllers\sidebar\SidebarController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\Firstuserlogin;
use Illuminate\Support\Facades\Session;


class LoginController extends Controller
{

    public function index(Request $request)
    {
        $info = DB::table('info_institucional')->where('id', 1)->first();
        
        if (Auth::guard('company')->check()) {
            //
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            
            if ($userTypeAccesocombo == "4" ) {
                $tipoacceso = 4;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('empresa.ofertas_laborales.index', [
                    'datatipoacceso' => $tipoacceso,
                    'info' => $info, // << pasas la data al blade
                ]);
            } else if ($userTypeAccesocombo == "1"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return view('welcome', ['info' => $info]);
        }
    }

    public function registration()
    {
        return view('auth.register');
    }

    public function authenticateLogin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'identificationtype_id' => 'required',
            'nroidenti' => 'required|min:8|max:12',
            'password' => 'required'
        ], [
            'nroidenti.min' => 'El código no cuenta con la cantidad de carácteres requeridos',
            'nroidenti.max' => 'El código no cuenta con la cantidad de carácteres requeridos',
        ]);
        
        if ($validator->fails()) {
            return response()->json([
                "status" => false,
                "errors" => $validator->errors(),
                "message" => "Digite bien los campos!"
            ]);
        } else {
            // OBTENER TIPO DE USUARIO
            $txt_usertype = $request->input('txt_usertype');
            // $txt_usertype = 2;
            
            if (Auth::attempt($request->only(["identificationtype_id", "nroidenti", "password"]))) {
                
                if (Auth::User()->estado == 1) {
                    
                    /*
                        TIPOS DE USUARIO
                            1: admin
                            2: docente
                            3: alumno
                            4: admin-docente
                            5: admin-alumno
                            6: docente-alumno
                            7: admin-docente-alumno
                    */
                    
                    $idusertype = Auth::User()->usertype_id;
                    
                    // TIPO DE USUARIO
                    
                    // txt_usertype : administrador
                    if ($txt_usertype == 1) {
                        if ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7") {
                            $ruta = 'home.adm.dashboard'; // Redirige a la página de inicio si el rol no coincide
                        } else {
                            Auth::logout(); // Cerrar sesión si el usuario no está activo
                            return response()->json(["status" => false, "errors" => ["Credenciales inválidas"], "message" => "Credenciales inválidas!"]);
                        }
                    }
                    
                    // txt_usertype : docente
                    if ($txt_usertype == 2) {
                        if ($idusertype == "2" || $idusertype == "4" || $idusertype == "6" || $idusertype == "7") {
                            $ruta = 'home.docente.index'; // Redirige a la página de inicio si el rol no coincide
                        } else {
                            Auth::logout(); // Cerrar sesión si el usuario no está activo
                            return response()->json(["status" => false, "errors" => ["Credenciales inválidas"], "message" => "Credenciales inválidas!"]);
                        }
                    }
                    
                    // txt_usertype : alumno
                    if ($txt_usertype == 3) {
                        if ($idusertype == "3" || $idusertype == "5" || $idusertype == "6" || $idusertype == "7") {
                            $ruta = 'home.student.index'; // Redirige a la página de inicio si el rol no coincide
                        } else {
                            Auth::logout(); // Cerrar sesión si el usuario no está activo
                            return response()->json(["status" => false, "errors" => ["Credenciales inválidas"], "message" => "Credenciales inválidas!"]);
                        }
                    }
                    
                    $request->session()->put('userTypeAccesocombo', $txt_usertype);
                    
                    //si el usuario esta autentificado y esta activo
                    return response()->json([
                        "status" => true,
                        "message" => "Credenciales correctas",
                        "redirect" => route($ruta)
                    ]);
                } else {
                    
                    Auth::logout(); // Cerrar sesión si el usuario no está activo
                    return response()->json([
                        "status" => false,
                        "message" => "Usuario inactivo, consulte con el administrador!"
                    ]);
                }
            } else {
                return response()->json([
                    "status" => false,
                    "errors" => ["Credenciales inválidas"],
                    "message" => "Credenciales inválidas!"

                ]);
            }
        }
    }


    public function authenticateLoginCompany(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'ruc' => 'required|min:10|max:30',
            'password' => 'required'
        ], [
            'ruc.min' => 'El código no cuenta con la cantidad de caracteres requeridos',
            'ruc.max' => 'El código no cuenta con la cantidad de caracteres requeridos',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => false,
                "errors" => $validator->errors(),
                "message" => "Digite bien los campos!"
            ]);
        }

        // OBTENER TIPO DE USUARIO
        $txt_usertype = $request->input('txt_usertype');

        // Autenticar al usuario usando el guard personalizado de empresa
        if (Auth::guard('company')->attempt($request->only(["ruc", "password"]))) {

            $company = Auth::guard('company')->user();

            if ($company->estado == 1) {

                $request->session()->put('userTypeAccesocombo', $txt_usertype);
                
                return response()->json([
                    "status" => true,
                    "message" => "Credenciales correctas",
                    "redirect" => route('empresa.ofertas_laborales') // Define tu ruta para dashboard
                ]);
            } else {
                Auth::guard('company')->logout();
                return response()->json([
                    "status" => false,
                    "message" => "Empresa inactiva, consulte con el administrador!"
                ]);
            }
        } else {
            return response()->json([
                "status" => false,
                "errors" => ["Credenciales inválidas"],
                "message" => "Credenciales inválidas!"
            ]);
        }
    }

    public function dashboard(Request $request)
    {
        //instanciando objeto del controlador sidebar
        $objeto = new SidebarController();
        //con el objeto llamamos la funcion listar modulos
        $sidebar = $objeto->ListmodulosSidebar();
        
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            
            // VALIDACION TIPO DE USUARIO
            $idusertype = Auth::User()->usertype_id;
            
            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $tipoacceso = 1;
                return view('admin.bolsa_laboral.ofertas_laborales.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function homeDocentes(Request $request)
    {

        if (Auth::check()) {

            $result = Firstuserlogin::where('nroidenti', Auth::User()->nroidenti)->first();

            if ($result) {
                view()->share('modal_mensajeversion', false);
            } else {
                view()->share('modal_mensajeversion', true);
            }


            // VALIDACION TIPO DE USUARIO
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "2" && ($idusertype == "2" || $idusertype == "4" || $idusertype == "6" || $idusertype == "7")) {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 2;
                return view('docente.ofertas_laborales.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function homeStudent(Request $request)
    {

        if (Auth::check()) {

            $result = Firstuserlogin::where('nroidenti', Auth::User()->nroidenti)->first();

            if ($result) {
                view()->share('modal_mensajeversion', false);
            } else {
                view()->share('modal_mensajeversion', true);
            }

            // VALIDACION TIPO DE USUARIO
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "3" && ($idusertype == "3" || $idusertype == "5" || $idusertype == "6" || $idusertype == "7")) {
                $tipoacceso = 3;
                return view('alumno.ofertas_laborales.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function confirmarNotificacionUpdateVersion(Request $request)
    {

        $item = new Firstuserlogin();
        $item->nroidenti = Auth::User()->nroidenti;
        $item->estado = "1";
        if ($item->save()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Noticación Recibida',
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Noticación no Recibida'
            ]);
        }
    }

    public function logout(Request $request)
    {
        Session::flush();
        Auth::logout();
        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return response()->json([
            "status" => true,
            "message" => "Cerrando sesion",
            "redirect" => route('login')
        ]);
    }
}
