<?php

namespace App\Http\Controllers;

use App\Models\Applicant;
use App\Models\Identificationtype;
use App\Models\Jpjobapplication;
use App\Models\Plan;
use App\Models\Planequivalence;
use App\Models\Program;
use App\Models\Semester;
use App\Models\Semesterenrollment;
use App\Models\Student;
use App\Models\Studentdocument;
use App\Models\Subject;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Response;
use Illuminate\Support\Str;

class FileController extends Controller
{

    public function verBoucherMatricula($idstudent, $idsemesterenrollment)
    {
        $item = Student::where('id', $idstudent)->first();
        $iduser = $item->user_id;

        $item = User::where('id', $iduser)->first();
        $nroidenti = $item->nroidenti;

        $item = Semesterenrollment::where('id', $idsemesterenrollment)->first();
        $idsemester = $item->semester_id;

        $item = Semester::where('id', $idsemester)->first();
        $anho = $item->anho;
        $numero = $item->numero;

        $file = storage_path('app/students/' . $idstudent . '/bouchers_matricula/') . $idsemesterenrollment . '.pdf';
        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $fileTitle = 'ID_' . $nroidenti . ' - PERIODO_' . $anho . '_' . $numero . '.pdf';
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }


    public function verDocumentoEstudiante($idstudent, $idstudentdocument)
    {
        $item = Student::where('id', $idstudent)->first();
        $iduser = $item->user_id;

        $item = User::where('id', $iduser)->first();
        $tipoidenti = $item->tipoidenti;
        $nroidenti = $item->nroidenti;

        $item = Studentdocument::where('id', $idstudentdocument)->first();
        $nombre = $item->nombre;

        $file = storage_path('app/students/' . $idstudent . '/reservas_licencias/') . $idstudentdocument . '.pdf';
        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $fileTitle = '' . $tipoidenti . '_' . $nroidenti . ' - TIPO_' . $nombre . '.pdf';
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }

    public function verDocumentoEquivalencia($idprogram, $idplanequivalence)
    {
        $item = Program::where('id', $idprogram)->first();
        $nomprogram = $item->nombre;

        $item = Planequivalence::where('id', $idplanequivalence)->first();
        $idplan1 = $item->plan_id1;
        $idplan2 = $item->plan_id2;

        $item = Plan::where('id', $idplan1)->first();
        $nomplan1 = $item->nombre;

        $item = Plan::where('id', $idplan2)->first();
        $nomplan2 = $item->nombre;

        $file = storage_path('app/programs/' . $idprogram . '/equivalencias/') . $idplanequivalence . '.pdf';
        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $fileTitle = 'Programa_' . $nomprogram . ' - Equivalencia_' . $nomplan1 . '_' . $nomplan2 . '.pdf';
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }

    public function verSilabo($idsubject)
    {
        $item = Subject::find($idsubject);
        $item->silabo;

        $file = storage_path('app/') . $item->silabo;
        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            // $fileTitle = '' . $tipoidenti . '_' . $nroidenti . ' - TIPO_' . $nombre . '.pdf';
            $fileTitle = '.pdf';
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }

    public function verInstrumentosEvaluacion($idsubject)
    {
        $item = Subject::find($idsubject);
        $item->instrumentos_evaluacion;

        $file = storage_path('app/') . $item->instrumentos_evaluacion;
        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            // $fileTitle = '' . $tipoidenti . '_' . $nroidenti . ' - TIPO_' . $nombre . '.pdf';
            $fileTitle = '.pdf';
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }

    public function donwloadManualdetramitedocumentario()
    {

        $fileName = 'public/Manuales/tramite/manual.pdf';

        $file = storage_path('app/' . $fileName);

        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $cadenaAleatoria = Str::random(20);
            $fileTitle = 'Manual_de_usuario_N°_' . $cadenaAleatoria . 'pdf';

            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            return response()->json(['error' => 'Archivo no encontrado'], 404);
        }
    }


    public function donwloadManualderequicitostramitedocumentario()
    {

        $fileName = 'public/Manuales/requisitos/requisitos.pdf';

        $file = storage_path('app/' . $fileName);

        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $cadenaAleatoria = Str::random(20);
            $fileTitle = 'Manual_N°_' . $cadenaAleatoria . 'pdf';

            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            return response()->json(['error' => 'Archivo no encontrado'], 404);
        }
    }


    public function verCurriculumVitae($idjobapplication)
    {
        $item = Jpjobapplication::find($idjobapplication);
        $item->isvisto = '1';
        $item->save();

        $item->documento;

        $file = storage_path('app/') . $item->documento;
        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            // $fileTitle = '' . $tipoidenti . '_' . $nroidenti . ' - TIPO_' . $nombre . '.pdf';
            $fileTitle = '.pdf';
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }


    public function verCurriculumVitae2($idjobapplication)
    {
        $item = Jpjobapplication::find($idjobapplication);
        // $item->isvisto = '1';
        // $item->save();

        $item->documento;

        $file = storage_path('app/') . $item->documento;
        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            // $fileTitle = '' . $tipoidenti . '_' . $nroidenti . ' - TIPO_' . $nombre . '.pdf';
            $fileTitle = '.pdf';
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }


    public function verPostulanteDNI($idapplicant)
    {
        $item = Applicant::find($idapplicant);
        $nroidenti = $item->nroidenti;

        $item2 = Identificationtype::where('id', $item->identificationtype_id)->first();
        $tipoidenti = $item2->tipo;

        $file = storage_path('app/') . $item->docdni;
        if (file_exists($file)) {
            $extension = pathinfo($file, PATHINFO_EXTENSION);

            // Verificar la extensión y establecer el tipo de contenido correspondiente
            switch ($extension) {
                case 'pdf':
                    $contentType = 'application/pdf';
                    break;
                case 'png':
                    $contentType = 'image/png';
                    break;
                case 'jpg':
                case 'jpeg':
                    $contentType = 'image/jpeg';
                    break;
                default:
                    abort(404, 'Formato de archivo no admitido.');
            }

            $headers = [
                'Content-Type' => $contentType,
            ];

            $fileTitle = $tipoidenti . '_' . $nroidenti . '.' . $extension;
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }

    public function verPostulanteCertificado($idapplicant)
    {
        $item = Applicant::find($idapplicant);
        $nroidenti = $item->nroidenti;

        $item2 = Identificationtype::where('id', $item->identificationtype_id)->first();
        $tipoidenti = $item2->tipo;

        $file = storage_path('app/') . $item->doccertif;
        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $fileTitle = $tipoidenti . '_' . $nroidenti . '.pdf';
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }

    public function verPostulanteBoucher($idapplicant)
    {
        $item = Applicant::find($idapplicant);
        $nroidenti = $item->nroidenti;

        $item2 = Identificationtype::where('id', $item->identificationtype_id)->first();
        $tipoidenti = $item2->tipo;

        $file = storage_path('app/') . $item->docboucher;
        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $fileTitle = $tipoidenti . '_' . $nroidenti . '.pdf';
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }


    public function verPostulanteDatosPersonales($idapplicant)
    {
        $item = Applicant::find($idapplicant);
        $nroidenti = $item->nroidenti;

        $item2 = Identificationtype::where('id', $item->identificationtype_id)->first();
        $tipoidenti = $item2->tipo;

        $file = storage_path('app/') . $item->docdatosper;
        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $fileTitle = $tipoidenti . '_' . $nroidenti . '.pdf';
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }
}
